/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mwllactionmapper.MWLLActionmapperView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionMaps {
    private static Document actionMapsDoc;

    public static boolean validateActionMaps(File actionMapsFile) {
        if (actionMapsFile == null) {
            return false;
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document thisDoc = docBuilder.parse(actionMapsFile);
            thisDoc.getDocumentElement().normalize();
            NodeList actionMapsTag = thisDoc.getElementsByTagName("actionmap");
            if (actionMapsTag.getLength() == 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void exportActionMaps(File exportMapsFile) {
        if (actionMapsDoc == null) {
            return;
        }
        try {
            DOMSource source = new DOMSource(actionMapsDoc);
            StreamResult result = new StreamResult(exportMapsFile);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Document getActionMapsFromStream(InputStream is) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(is);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static void importActionMapsFromStream(InputStream is) {
        actionMapsDoc = ActionMaps.getActionMapsFromStream(is);
    }

    public static void importActionMaps(File actionMapsFile) {
        if (actionMapsFile == null) {
            return;
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            actionMapsDoc = docBuilder.parse(actionMapsFile);
            actionMapsDoc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addActionElement(Document doc, String actionMap, Element element) {
        if (doc == null || actionMap == null || element == null) {
            return;
        }
        NodeList actionMapsList = doc.getElementsByTagName("actionmap");
        for (int i = 0; i < actionMapsList.getLength(); ++i) {
            Element actionMapElement;
            Node actionMapNode = actionMapsList.item(i);
            if (actionMapNode.getNodeType() != 1 || !(actionMapElement = (Element)actionMapNode).getAttribute("name").equals(actionMap)) continue;
            actionMapElement.appendChild(element);
        }
    }

    private static void deleteActionElement(Document doc, String actionMap, Element element) {
        if (doc == null || actionMap == null || element == null) {
            return;
        }
        NodeList actionMapsList = doc.getElementsByTagName("actionmap");
        for (int i = 0; i < actionMapsList.getLength(); ++i) {
            Element actionMapElement;
            Node actionMapNode = actionMapsList.item(i);
            if (actionMapNode.getNodeType() != 1 || !(actionMapElement = (Element)actionMapNode).getAttribute("name").equals(actionMap)) continue;
            actionMapElement.removeChild(element);
        }
    }

    private static Element getActionElement(Document doc, String actionMap, String action) {
        if (doc == null || actionMap == null || action == null) {
            return null;
        }
        NodeList actionMapsList = doc.getElementsByTagName("actionmap");
        for (int i = 0; i < actionMapsList.getLength(); ++i) {
            Element actionMapElement;
            Node actionMapNode = actionMapsList.item(i);
            if (actionMapNode.getNodeType() != 1 || !(actionMapElement = (Element)actionMapNode).getAttribute("name").equals(actionMap)) continue;
            NodeList actionList = actionMapElement.getElementsByTagName("action");
            int numActions = actionList.getLength();
            for (int j = 0; j < numActions; ++j) {
                Element actionElement = (Element)actionList.item(j);
                if (!actionElement.getAttribute("name").equals(action)) continue;
                return actionElement;
            }
        }
        return null;
    }

    public static void setToggleModeOnKey(String actionMap, String action, boolean toggleMode) {
        if (actionMap == null || action == null) {
            return;
        }
        Element actionElement = ActionMaps.getActionElement(actionMapsDoc, actionMap, action);
        if (actionElement == null) {
            return;
        }
        String onReleaseValue = toggleMode ? "0" : "1";
        actionElement.setAttribute("onRelease", onReleaseValue);
    }

    public static boolean getToggleModeOnKey(String actionMap, String action) {
        if (actionMap == null || action == null) {
            return false;
        }
        Element actionElement = ActionMaps.getActionElement(actionMapsDoc, actionMap, action);
        if (actionElement == null) {
            return false;
        }
        boolean toggleMode = !"1".equals(actionElement.getAttribute("onRelease"));
        return toggleMode;
    }

    public static void setActionKeys(String actionMap, String action, List<String> inputKeys) {
        block14: {
            int numKeys;
            NodeList keyList;
            Element actionElement;
            int numInputKeys;
            block13: {
                if (actionMap == null || action == null || actionMapsDoc == null) {
                    return;
                }
                if ("hud_show_multiplayer_scoreboard".equals(action)) {
                    ActionMaps.setActionKeys(actionMap, "hud_hide_multiplayer_scoreboard", inputKeys);
                }
                if (inputKeys == null) {
                    inputKeys = new ArrayList<String>();
                }
                if (inputKeys.size() < 1) {
                    inputKeys.add("null");
                }
                boolean hasNonNullInput = false;
                for (int i = 0; i < inputKeys.size(); ++i) {
                    if (inputKeys.get(i) == null || inputKeys.get(i).length() == 0) {
                        inputKeys.set(i, "null");
                        continue;
                    }
                    if ("null".equals(inputKeys.get(i))) continue;
                    hasNonNullInput = true;
                }
                boolean forceRetrieveActionFromDefault = !hasNonNullInput;
                numInputKeys = inputKeys.size();
                actionElement = ActionMaps.getActionElement(actionMapsDoc, actionMap, action);
                if (actionElement == null || forceRetrieveActionFromDefault) {
                    Document defaultActionMapsDoc = ActionMaps.getActionMapsFromStream(MWLLActionmapperView.reference.getClass().getResourceAsStream("resources/actionmaps_default.xml"));
                    Element newActionElement = ActionMaps.getActionElement(defaultActionMapsDoc, actionMap, action);
                    if (newActionElement != null) {
                        newActionElement = (Element)actionMapsDoc.importNode(newActionElement, true);
                        if (forceRetrieveActionFromDefault) {
                            ActionMaps.deleteActionElement(actionMapsDoc, actionMap, actionElement);
                        }
                        ActionMaps.addActionElement(actionMapsDoc, actionMap, newActionElement);
                    }
                    actionElement = newActionElement;
                }
                if (actionElement == null) {
                    return;
                }
                keyList = actionElement.getElementsByTagName("key");
                numKeys = keyList.getLength();
                for (int k = 0; k < numKeys; ++k) {
                    Element keyElement = (Element)keyList.item(k);
                    if (k >= numInputKeys) continue;
                    keyElement.setAttribute("name", inputKeys.get(k));
                }
                if (numKeys >= numInputKeys) break block13;
                while (numKeys < numInputKeys) {
                    Element firstElement = (Element)keyList.item(0);
                    Element newElement = (Element)firstElement.cloneNode(false);
                    newElement.setAttribute("name", inputKeys.get(++numKeys - 1));
                    actionElement.appendChild(newElement);
                }
                break block14;
            }
            if (numKeys <= numInputKeys) break block14;
            while (numKeys > numInputKeys) {
                actionElement.removeChild(keyList.item(--numKeys - 1));
            }
        }
    }

    public static List<String> getActionKeys(String actionMap, String action) {
        if (actionMap == null || action == null || actionMapsDoc == null) {
            return null;
        }
        boolean actionFound = false;
        ArrayList<String> keys = new ArrayList<String>(2);
        Element actionElement = ActionMaps.getActionElement(actionMapsDoc, actionMap, action);
        if (actionElement == null) {
            return null;
        }
        actionFound = true;
        NodeList keyList = actionElement.getElementsByTagName("key");
        int numKeys = keyList.getLength();
        for (int k = 0; k < numKeys; ++k) {
            Element keyElement = (Element)keyList.item(k);
            keys.add(keyElement.getAttribute("name"));
        }
        if (!actionFound) {
            return null;
        }
        return keys;
    }
}

