/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.enums;

import java.util.HashSet;
import java.util.Set;
import mwllactionmapper.enums.IControlSelection;

public enum MouseControlSelection implements IControlSelection
{
    MOUSE_UNKNOWN(null, null, new String[0]),
    MOUSE_1("Mouse Left", "mouse1", "Left"),
    MOUSE_2("Mouse Right", "mouse2", "Right"),
    MOUSE_3("Mouse Middle", "mouse3", "Middle"),
    MOUSE_4("Mouse 4", "mouse4", "4"),
    MOUSE_5("Mouse 5", "mouse5", "5"),
    MOUSE_6("Mouse 6", "mouse6", "6"),
    MOUSE_7("Mouse 7", "mouse7", "7"),
    MOUSE_8("Mouse 8", "mouse8", "8"),
    MOUSE_9("Mouse 9", "mouse9", "9");

    private MouseControlSelection[] controls = null;
    protected String displayName;
    protected String keyName;
    protected Set<String> aliases;

    private MouseControlSelection(String displayName, String keyName, String ... aliases) {
        this.setDisplayName(displayName);
        this.setKeyName(keyName);
        if (aliases != null) {
            this.aliases = new HashSet<String>();
            for (String alias : aliases) {
                this.aliases.add(alias);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    protected void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public MouseControlSelection getControlSelection(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.controls == null) {
            this.controls = new MouseControlSelection[]{MOUSE_1, MOUSE_2, MOUSE_3, MOUSE_4, MOUSE_5, MOUSE_6, MOUSE_7, MOUSE_8, MOUSE_9};
        }
        for (MouseControlSelection control : this.controls) {
            Set<String> strings = control.getAliases();
            if (!strings.contains(alias)) continue;
            return control;
        }
        return MOUSE_UNKNOWN;
    }
}

