/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.enums;

import java.util.HashSet;
import java.util.Set;
import mwllactionmapper.enums.IControlSelection;

public enum X360GameControlSelection implements IControlSelection
{
    GAME_UNKNOWN(null, null, new String[0]),
    GAME_A("Button A", "xi_a", "0"),
    GAME_B("Button B", "xi_b", "1"),
    GAME_X("Button X", "xi_x", "2"),
    GAME_Y("Button Y", "xi_y", "3"),
    GAME_LEFT_SHOULDER("Button Left Shoulder", "xi_shoulderl", "4"),
    GAME_RIGHT_SHOULDER("Button Right Shoulder", "xi_shoulderr", "5"),
    GAME_BACK("Button Back", "xi_back", "6"),
    GAME_START("Button Start", "xi_start", "7"),
    GAME_LEFT_STICK("Button Left Stick", "xi_thumbl", "8"),
    GAME_RIGHT_STICK("Button Right Stick", "xi_thumbr", "9");

    private X360GameControlSelection[] controls = null;
    protected String displayName;
    protected String keyName;
    protected Set<String> aliases;

    private X360GameControlSelection(String displayName, String keyName, String ... aliases) {
        this.setDisplayName(displayName);
        this.setKeyName(keyName);
        if (aliases != null) {
            this.aliases = new HashSet<String>();
            for (String alias : aliases) {
                this.aliases.add(alias);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    protected void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public X360GameControlSelection getControlSelection(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.controls == null) {
            this.controls = new X360GameControlSelection[]{GAME_A, GAME_B, GAME_X, GAME_Y, GAME_LEFT_SHOULDER, GAME_RIGHT_SHOULDER, GAME_BACK, GAME_START, GAME_LEFT_STICK, GAME_RIGHT_STICK};
        }
        for (X360GameControlSelection control : this.controls) {
            Set<String> strings = control.getAliases();
            if (!strings.contains(alias)) continue;
            return control;
        }
        return GAME_UNKNOWN;
    }
}

