/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class JoystickCfgModel {
    public static final int MOD_SENSITIVITY = 0;
    public static final int MOD_DEADZONE = 1;
    public static final int MOD_MINIMUM = 2;
    public static final int MOD_MAXIMUM = 3;
    public static final int MOD_JOY_ID = 4;
    public static final int[][] MOD_RANGES = new int[][]{{0, 50}, {1, 1000}, {-1000, 1}, {1, 1000}, {1, 5}};
    public static final int[][] MOD_RANGE_TICKS = new int[][]{{5, 25}, {50, 200}, {50, 200}, {50, 200}, {0, 1}};
    public static final String[][] MOD_RANGE_LABELS = new String[][]{{"Less sensitive", "More sensitive"}, {"Smaller deadzone", "Larger deadzone"}, {"More range", "Less range"}, {"Less range", "More range"}, {null, null}};
    public Properties joystickSettings;
    private List<String> joyCfgKeyOrder;

    public void importJoystickCfgFile(File joystickCfgFile) {
        this.joystickSettings = new Properties();
        this.joyCfgKeyOrder = new ArrayList<String>();
        if (joystickCfgFile == null || !joystickCfgFile.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(joystickCfgFile);
            this.joystickSettings.load(is);
            BufferedReader r = new BufferedReader(new FileReader(joystickCfgFile));
            this.storeKeyOrder(r);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importJoystickCfgDefault() {
        this.joystickSettings = new Properties();
        try {
            this.joystickSettings.load(this.getClass().getResourceAsStream("/mwllactionmapper/resources/joystick_default.cfg"));
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/mwllactionmapper/resources/joystick_default.cfg")));
            this.storeKeyOrder(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void storeKeyOrder(BufferedReader r) {
        this.joyCfgKeyOrder = new ArrayList<String>();
        if (r == null) {
            return;
        }
        try {
            String line = r.readLine();
            while (line != null) {
                StringTokenizer tk = new StringTokenizer(line, "=");
                if (tk.countTokens() > 0) {
                    String keyToken = tk.nextToken().trim();
                    this.joyCfgKeyOrder.add(keyToken);
                }
                line = r.readLine();
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportJoystickCfg(File joystickCfgFile) {
        if (this.joystickSettings == null || joystickCfgFile == null) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(joystickCfgFile)));
            StringBuffer writeStrBuffer = new StringBuffer();
            for (String key : this.joyCfgKeyOrder) {
                String value = this.joystickSettings.getProperty(key);
                if (value == null) continue;
                writeStrBuffer.append(key + " = " + value + "\n");
            }
            out.write(writeStrBuffer.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSettingName(String settingKey) {
        if (settingKey == null) {
            return "NULL";
        }
        if (settingKey.equals("joystick")) {
            return "Joystick ID";
        }
        String settingName = "";
        StringTokenizer tk = new StringTokenizer(settingKey, "_");
        int index = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            switch (index) {
                case 0: {
                    settingName = settingName + JoystickCfgModel.getAxisDisplayName(token) + " ";
                    break;
                }
                case 1: {
                    settingName = settingName + JoystickCfgModel.getAxisTypeName(token) + " ";
                    break;
                }
                case 2: {
                    settingName = settingName + JoystickCfgModel.getAxisModName(token);
                    break;
                }
            }
            ++index;
        }
        return settingName;
    }

    public static String getAxisModName(String axisModStr) {
        if (axisModStr.equals("att")) {
            return "Sensitivity";
        }
        if (axisModStr.equals("off")) {
            return "Deadzone";
        }
        if (axisModStr.equals("min")) {
            return "Minimum";
        }
        if (axisModStr.equals("max")) {
            return "Maximum";
        }
        return axisModStr;
    }

    public static String getAxisTypeName(String axisTypeStr) {
        if (axisTypeStr.equals("axis")) {
            return "Axis";
        }
        if (axisTypeStr.equals("rot")) {
            return "Rotation";
        }
        return axisTypeStr;
    }

    public static String getAxisDisplayName(String axisStr) {
        int strLen = axisStr.length();
        if (strLen == 1) {
            return axisStr.toUpperCase();
        }
        return axisStr.substring(0, 1).toUpperCase() + axisStr.substring(1, strLen);
    }

    public static int getModValue(String key) {
        if (key.endsWith("att")) {
            return 0;
        }
        if (key.endsWith("off")) {
            return 1;
        }
        if (key.endsWith("min")) {
            return 2;
        }
        if (key.endsWith("max")) {
            return 3;
        }
        return 4;
    }
}

