/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateModel {
    public static List<Template> getTemplateListing() {
        File templateDir;
        String[] children;
        ArrayList<Template> templateList = new ArrayList<Template>();
        String launchDir = System.getProperty("user.dir");
        if (launchDir.contains("NetBeans")) {
            launchDir = launchDir + "\\dist";
        }
        if ((children = (templateDir = new File(launchDir, "templates")).list()) == null) {
            return templateList;
        }
        block2: for (String child : children) {
            if (!child.endsWith("xml")) continue;
            File templateFile = new File(templateDir, child);
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document templateDoc = docBuilder.parse(templateFile);
                templateDoc.getDocumentElement().normalize();
                NodeList actionMapsList = templateDoc.getElementsByTagName("template");
                for (int i = 0; i < actionMapsList.getLength(); ++i) {
                    Node n = actionMapsList.item(i);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    String templateName = e.getAttribute("name");
                    String templateDescription = e.getAttribute("description").replaceAll("@br@", System.getProperty("line.separator"));
                    templateList.add(new Template(templateFile, templateName, templateDescription));
                    continue block2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return templateList;
    }

    public static class Template {
        File file;
        String name;
        String description;

        public Template(File file, String name, String description) {
            this.file = file;
            this.name = name;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

