/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.keypoller;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.enums.IControlSelection;
import mwllactionmapper.enums.KeyControlSelection;
import mwllactionmapper.enums.UnknownControlSelection;
import mwllactionmapper.keypoller.JInputScanner;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class PollDialog
extends JDialog {
    private static String pressedKeyButton;
    private JPanel backgroundPanel;
    private JLabel pressCancelLbl;
    private JLabel pressInfoLbl;
    private JLabel pressKeyLbl;

    public PollDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocation(parent.getX() + 200, parent.getY() + 200);
        pressedKeyButton = null;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.pressKeyLbl = new JLabel();
        this.pressInfoLbl = new JLabel();
        this.pressCancelLbl = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getResourceMap(PollDialog.class);
        this.setTitle(resourceMap.getString("Poll Dialog.title", new Object[0]));
        this.setAlwaysOnTop(true);
        this.setCursor(new Cursor(0));
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("Poll Dialog");
        this.setResizable(false);
        this.backgroundPanel.setBackground(resourceMap.getColor("backgroundPanel.background"));
        this.backgroundPanel.setName("backgroundPanel");
        this.pressKeyLbl.setFont(resourceMap.getFont("pressKeyLbl.font"));
        this.pressKeyLbl.setHorizontalAlignment(0);
        this.pressKeyLbl.setText(resourceMap.getString("pressKeyLbl.text", new Object[0]));
        this.pressKeyLbl.setHorizontalTextPosition(0);
        this.pressKeyLbl.setName("pressKeyLbl");
        this.pressInfoLbl.setHorizontalAlignment(0);
        this.pressInfoLbl.setText(resourceMap.getString("pressInfoLbl.text", new Object[0]));
        this.pressInfoLbl.setName("pressInfoLbl");
        this.pressCancelLbl.setHorizontalAlignment(0);
        this.pressCancelLbl.setText(resourceMap.getString("pressCancelLbl.text", new Object[0]));
        this.pressCancelLbl.setName("pressCancelLbl");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pressKeyLbl, -1, -1, Short.MAX_VALUE).addComponent(this.pressCancelLbl, -1, 562, Short.MAX_VALUE).addComponent(this.pressInfoLbl, -1, 562, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(71, 71, 71).addComponent(this.pressKeyLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pressInfoLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 57, Short.MAX_VALUE).addComponent(this.pressCancelLbl).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    public static String showPollDialog(String actionName) {
        final PollDialog dialog = new PollDialog((Frame)MWLLActionmapperView.reference.getFrame(), true);
        if (actionName != null && actionName.length() > 0) {
            String pressKeyStr = "Please press a key or button to assign for '" + actionName + "'";
            dialog.pressKeyLbl.setText(pressKeyStr);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JInputScanner scanner = new JInputScanner();
                IControlSelection directInputSelection = scanner.getControlSelection(dialog.backgroundPanel);
                if (directInputSelection == null) {
                    JOptionPane.showMessageDialog(dialog, "No key/button detected.", "No key/button detected", 0);
                } else if (directInputSelection.equals(UnknownControlSelection.CONTROL_UNKNOWN) || directInputSelection.getKeyName() == null) {
                    System.out.println("unkown inputSelection=" + directInputSelection.getDisplayName() + ", " + directInputSelection.getKeyName());
                    JOptionPane.showMessageDialog(dialog, "Key/Button is not yet supported by this detection tool, try selecting manually if available.", "Key/Button not supported", 0);
                } else if (!directInputSelection.equals(KeyControlSelection.KEY_ESC)) {
                    System.out.println("accepted inputSelection=" + directInputSelection.getDisplayName() + ", " + directInputSelection.getKeyName());
                    pressedKeyButton = directInputSelection.getKeyName();
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
        return pressedKeyButton;
    }
}

