/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.awt.Color;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.model.JoystickCfgModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class JoystickCfgModPanel
extends JPanel
implements ChangeListener {
    private String settingName;
    private boolean isEnabled = true;
    private int multiplier = 1;
    private JLabel leftSliderLbl;
    private JTextField modSettingField;
    private JLabel modSettingLbl;
    private JSlider modSettingSlider;
    private JLabel rightSliderLbl;

    public JoystickCfgModPanel(String settingLabel, String settingName) {
        this.initComponents();
        this.settingName = settingName;
        this.modSettingLbl.setText(settingLabel);
        this.modSettingLbl.setToolTipText(settingName);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.leftSliderLbl.setEnabled(enabled);
            this.rightSliderLbl.setEnabled(enabled);
            this.modSettingSlider.setEnabled(enabled);
            this.modSettingField.setEnabled(enabled);
            this.modSettingLbl.setEnabled(enabled);
            this.updateUI();
        }
    }

    public void setModified(boolean isModified) {
        if (isModified) {
            MWLLActionmapperView.reference.setWorkingFileModified(true);
        } else {
            this.modSettingLbl.setForeground(Color.BLACK);
            this.modSettingLbl.setIcon(null);
        }
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setSliderVisible(boolean visible) {
        this.leftSliderLbl.setVisible(visible);
        this.rightSliderLbl.setVisible(visible);
        this.modSettingSlider.setVisible(visible);
    }

    public void setLeftSliderLabel(String label) {
        this.leftSliderLbl.setText(label);
    }

    public void setRightSliderLabel(String label) {
        this.rightSliderLbl.setText(label);
    }

    public void setSliderMinValue(int min) {
        this.modSettingSlider.setMinimum(min * this.multiplier);
    }

    public void setSliderMaxValue(int max) {
        this.modSettingSlider.setMaximum(max * this.multiplier);
    }

    public void setSnapToSliderTicks(boolean snap) {
        this.modSettingSlider.setSnapToTicks(snap);
    }

    public void setSliderMinorTickSpacing(int minor) {
        this.modSettingSlider.setMinorTickSpacing(minor * this.multiplier);
    }

    public void setSliderMajorTickSpacing(int major) {
        this.modSettingSlider.setMajorTickSpacing(major * this.multiplier);
    }

    public int getSliderValue() {
        return this.modSettingSlider.getValue();
    }

    public void setInitialValue(String initialValue) {
        Double multValue = Double.valueOf(initialValue) * (double)this.multiplier;
        this.setValue(multValue.intValue());
        this.modSettingSlider.addChangeListener(this);
    }

    private void setValue(int value) {
        if (value == 0) {
            value = 1;
        }
        if (this.multiplier != 1) {
            double realValue = (double)value / (double)this.multiplier;
            this.modSettingField.setText(String.valueOf(realValue));
        } else {
            this.modSettingField.setText(String.valueOf(value));
        }
        this.setSliderValue(value);
    }

    private void setSliderValue(int value) {
        if (value < this.modSettingSlider.getMinimum()) {
            value = this.modSettingSlider.getMinimum();
        } else if (value > this.modSettingSlider.getMaximum()) {
            value = this.modSettingSlider.getMaximum();
        }
        this.modSettingSlider.setValue(value);
    }

    public String getSettingName() {
        return this.settingName;
    }

    private void updatePropertiesValue() {
        JoystickCfgModel joyCfg = MWLLActionmapperView.reference.workingJoyCfg;
        if (joyCfg == null) {
            return;
        }
        int value = this.getSliderValue();
        String valueStr = null;
        if (this.multiplier != 1) {
            Double realValue = Double.valueOf(value) / (double)this.multiplier;
            valueStr = String.valueOf(realValue);
        } else {
            valueStr = String.valueOf(value);
        }
        joyCfg.joystickSettings.setProperty(this.getSettingName(), valueStr);
    }

    private void initComponents() {
        this.modSettingLbl = new JLabel();
        this.modSettingField = new JTextField();
        this.leftSliderLbl = new JLabel();
        this.modSettingSlider = new JSlider();
        this.rightSliderLbl = new JLabel();
        ResourceMap resourceMap = Application.getInstance(MWLLActionmapperApp.class).getContext().getResourceMap(JoystickCfgModPanel.class);
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setName("Form");
        this.modSettingLbl.setFont(resourceMap.getFont("modSettingLbl.font"));
        this.modSettingLbl.setText(resourceMap.getString("modSettingLbl.text", new Object[0]));
        this.modSettingLbl.setName("modSettingLbl");
        this.modSettingField.setColumns(6);
        this.modSettingField.setEditable(false);
        this.modSettingField.setHorizontalAlignment(4);
        this.modSettingField.setText(resourceMap.getString("modSettingField.text", new Object[0]));
        this.modSettingField.setName("modSettingField");
        this.leftSliderLbl.setFont(resourceMap.getFont("leftSliderLbl.font"));
        this.leftSliderLbl.setHorizontalAlignment(4);
        this.leftSliderLbl.setText(resourceMap.getString("leftSliderLbl.text", new Object[0]));
        this.leftSliderLbl.setName("leftSliderLbl");
        this.modSettingSlider.setBackground(resourceMap.getColor("modSettingSlider.background"));
        this.modSettingSlider.setMinimum(-100);
        this.modSettingSlider.setPaintTicks(true);
        this.modSettingSlider.setValue(0);
        this.modSettingSlider.setName("modSettingSlider");
        this.rightSliderLbl.setFont(resourceMap.getFont("rightSliderLbl.font"));
        this.rightSliderLbl.setText(resourceMap.getString("rightSliderLbl.text", new Object[0]));
        this.rightSliderLbl.setName("rightSliderLbl");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.leftSliderLbl, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modSettingSlider, -2, 400, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightSliderLbl)).addGroup(layout.createSequentialGroup().addComponent(this.modSettingLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modSettingField, -2, -1, -2))).addContainerGap(87, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modSettingLbl).addComponent(this.modSettingField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightSliderLbl).addComponent(this.leftSliderLbl).addComponent(this.modSettingSlider, -2, -1, -2))));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.modSettingSlider) {
            String value = String.valueOf(this.modSettingSlider.getValue());
            this.setValue(Integer.valueOf(value));
            this.updatePropertiesValue();
            this.setModified(true);
        }
    }
}

