/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.awt.Component;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mwllactionmapper.JoystickCfgModPanel;
import mwllactionmapper.JoystickCfgSectionPanel;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.model.JoystickCfgModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class JoystickCfgPanel
extends JPanel {
    private JPanel joyCfgPanel;
    private JScrollPane joyCfgScrollPane;

    public JoystickCfgPanel() {
        this.initComponents();
    }

    public void reloadSettings() {
        this.joyCfgPanel.removeAll();
        JoystickCfgModel joyCfg = MWLLActionmapperView.reference.workingJoyCfg;
        if (joyCfg != null) {
            Vector<KeyString> sortedSettingKeys = new Vector<KeyString>();
            Enumeration<?> settingKeys = joyCfg.joystickSettings.propertyNames();
            while (settingKeys.hasMoreElements()) {
                String key = (String)settingKeys.nextElement();
                sortedSettingKeys.add(new KeyString(key));
            }
            Collections.sort(sortedSettingKeys);
            Hashtable<String, JoystickCfgSectionPanel> sectionTable = new Hashtable<String, JoystickCfgSectionPanel>();
            for (KeyString keyStr : sortedSettingKeys) {
                String key = keyStr.toString();
                String value = joyCfg.joystickSettings.getProperty(key);
                JoystickCfgModPanel joyPanel = new JoystickCfgModPanel(JoystickCfgModel.getSettingName(key), key);
                int modValue = JoystickCfgModel.getModValue(key);
                if (modValue == 0) {
                    joyPanel.setMultiplier(10);
                }
                joyPanel.setSliderMinValue(JoystickCfgModel.MOD_RANGES[modValue][0]);
                joyPanel.setSliderMaxValue(JoystickCfgModel.MOD_RANGES[modValue][1]);
                joyPanel.setSliderMinorTickSpacing(JoystickCfgModel.MOD_RANGE_TICKS[modValue][0]);
                joyPanel.setSliderMajorTickSpacing(JoystickCfgModel.MOD_RANGE_TICKS[modValue][1]);
                joyPanel.setSnapToSliderTicks(modValue == 4);
                joyPanel.setLeftSliderLabel(JoystickCfgModel.MOD_RANGE_LABELS[modValue][0]);
                joyPanel.setRightSliderLabel(JoystickCfgModel.MOD_RANGE_LABELS[modValue][1]);
                joyPanel.setInitialValue(value);
                String sectionName = this.getSectionName(key);
                JoystickCfgSectionPanel thisSectionPanel = null;
                if (!sectionTable.containsKey(sectionName)) {
                    thisSectionPanel = new JoystickCfgSectionPanel(sectionName);
                    sectionTable.put(sectionName, thisSectionPanel);
                    this.joyCfgPanel.add(thisSectionPanel);
                } else {
                    thisSectionPanel = (JoystickCfgSectionPanel)sectionTable.get(sectionName);
                }
                thisSectionPanel.addJoystickCfgModPanel(joyPanel);
            }
        }
        this.joyCfgPanel.updateUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component comp : this.joyCfgPanel.getComponents()) {
            comp.setEnabled(enabled);
        }
        this.joyCfgPanel.updateUI();
    }

    private String getSectionName(String key) {
        String sectionName = "";
        if (key == null || key.length() == 0) {
            return sectionName;
        }
        if (key.toLowerCase().equals("joystick")) {
            return "Joystick ID";
        }
        StringTokenizer tk = new StringTokenizer(key, "_");
        int index = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            switch (index) {
                case 0: {
                    sectionName = sectionName + JoystickCfgModel.getAxisDisplayName(token) + " ";
                    break;
                }
                case 1: {
                    sectionName = sectionName + JoystickCfgModel.getAxisTypeName(token) + " ";
                    break;
                }
                case 2: {
                    break;
                }
            }
            ++index;
        }
        return sectionName;
    }

    private void initComponents() {
        this.joyCfgScrollPane = new JScrollPane();
        this.joyCfgPanel = new JPanel();
        this.setName("Form");
        this.joyCfgScrollPane.setName("joyCfgScrollPane");
        ResourceMap resourceMap = Application.getInstance(MWLLActionmapperApp.class).getContext().getResourceMap(JoystickCfgPanel.class);
        this.joyCfgPanel.setBackground(resourceMap.getColor("joyCfgPanel.background"));
        this.joyCfgPanel.setName("joyCfgPanel");
        this.joyCfgPanel.setLayout(new BoxLayout(this.joyCfgPanel, 1));
        this.joyCfgScrollPane.setViewportView(this.joyCfgPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.joyCfgScrollPane, -1, 896, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.joyCfgScrollPane, -1, 532, Short.MAX_VALUE));
    }

    class KeyString
    implements Comparable<KeyString> {
        private String key;

        public KeyString(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        @Override
        public int compareTo(KeyString s) {
            if (s == null) {
                return -1;
            }
            if (s.key.equals(this.key)) {
                return 0;
            }
            if (this.key.equals("joystick")) {
                return -1;
            }
            if (s.key.equals("joystick")) {
                return 1;
            }
            if (this.key.startsWith("slider") || s.key.startsWith("slider")) {
                if (this.key.startsWith("slider") && s.key.startsWith("slider")) {
                    return this.subCompareTo(s);
                }
                if (this.key.startsWith("slider")) {
                    return 1;
                }
                return -1;
            }
            return this.subCompareTo(s);
        }

        private int subCompareTo(KeyString s) {
            String chkPreModKey;
            String thisPreModKey = this.key.substring(0, this.key.lastIndexOf("_"));
            if (thisPreModKey.equals(chkPreModKey = s.key.substring(0, s.key.lastIndexOf("_")))) {
                int chkModValue;
                int thisModValue = JoystickCfgModel.getModValue(this.key);
                if (thisModValue == (chkModValue = JoystickCfgModel.getModValue(s.key))) {
                    return 0;
                }
                if (thisModValue < chkModValue) {
                    return -1;
                }
                return 1;
            }
            return this.key.compareTo(s.key);
        }
    }
}

