/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.ActionPanel;
import mwllactionmapper.JoystickCfgPanel;
import mwllactionmapper.MWLLActionmapperAboutBox;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MappingPanel;
import mwllactionmapper.TemplatesDialog;
import mwllactionmapper.model.ActionModel;
import mwllactionmapper.model.ActionmapperProperties;
import mwllactionmapper.model.ActionmapsFileModel;
import mwllactionmapper.model.AutoexecModel;
import mwllactionmapper.model.FileCopy;
import mwllactionmapper.model.JoystickCfgModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MWLLActionmapperView
extends FrameView
implements WindowListener {
    private MappingPanel playerPanel;
    private MappingPanel vehiclePanel;
    private MappingPanel mechPanel;
    private MappingPanel tankPanel;
    private MappingPanel vtolPanel;
    private MappingPanel aerospacePanel;
    private JoystickCfgPanel joyPanel;
    private ActionmapsFileModel.ActionmapsFile workingFile;
    private long workingLastModified;
    private boolean workingHasMissingActions = false;
    private boolean workingHasBackup = false;
    public JoystickCfgModel workingJoyCfg;
    public AutoexecModel autoexecModel;
    private File profileDir;
    public static MWLLActionmapperView reference;
    private JFileChooser fc;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private JMenuItem activeMenuItem;
    private JLabel changeNoticeLabel;
    private JMenuItem deleteMenuItem;
    private JMenuItem dupeMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem guideMenuItem;
    private JMenuItem importMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPanel mainPanel;
    private JTabbedPane mainTabbedPane;
    private JMenuBar menuBar;
    private JMenuItem newMenuItem;
    private JPopupMenu popMenu;
    private JProgressBar progressBar;
    private JMenuItem renameMenuItem;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JMenuItem switchProfileItem;
    private JPanel toolbarPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public MWLLActionmapperView(SingleFrameApplication app) {
        super(app);
        try {
            AcrylLookAndFeel.setTheme("Default");
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        reference = this;
        ActionmapperProperties.loadActionmapperProperties();
        this.autoexecModel = new AutoexecModel();
        this.autoexecModel.importAutoexecCfgFile();
        this.initComponents();
        try {
            this.getFrame().setIconImage(new ImageIcon(this.getClass().getResource("resources/mwll.gif")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initPanels();
        this.doSelectProfile(true);
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MWLLActionmapperView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MWLLActionmapperView.this.busyIconIndex = (MWLLActionmapperView.this.busyIconIndex + 1) % MWLLActionmapperView.this.busyIcons.length;
                MWLLActionmapperView.this.statusAnimationLabel.setIcon(MWLLActionmapperView.this.busyIcons[MWLLActionmapperView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        this.getFrame().setBounds(0, 0, 1000, 600);
        this.getFrame().addWindowListener(this);
        this.fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?", "Existing file", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        FileNameExtensionFilter xmlfilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        this.fc.setFileFilter(xmlfilter);
        this.isCrysisRunning();
        this.startCrysisCheckThread();
    }

    private void startCrysisCheckThread() {
        ScheduledFuture<?> taskHandle = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                boolean foundCrysisRunning = false;
                try {
                    String line;
                    Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        if (!line.contains("\"Crysis.exe\"")) continue;
                        foundCrysisRunning = true;
                        break;
                    }
                    input.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ActionModel.isCrysisRunning() != foundCrysisRunning) {
                    ActionModel.setCrysisRunning(foundCrysisRunning);
                    reference.isCrysisRunning();
                }
            }
        }, 0L, 15L, TimeUnit.SECONDS);
    }

    public boolean isCrysisRunning() {
        boolean isCrysisRunning = ActionModel.isCrysisRunning();
        this.changeNoticeLabel.setVisible(isCrysisRunning);
        this.joyPanel.setEnabled(!isCrysisRunning);
        return isCrysisRunning;
    }

    @Action
    public void doExport() {
        this.statusMessageLabel.setText("Exporting...");
        this.fc.setDialogTitle("Export Actionmaps");
        this.fc.setCurrentDirectory(this.profileDir);
        int fcVal = this.fc.showSaveDialog(this.mainPanel);
        if (fcVal == 0) {
            File file = this.fc.getSelectedFile();
            File actionmapsFile = this.workingFile.getFile();
            try {
                FileCopy.copy(actionmapsFile.getAbsolutePath(), file.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.statusMessageLabel.setText("Error Exporting!");
                return;
            }
            this.statusMessageLabel.setText("Exported to " + file.getAbsolutePath());
        }
    }

    @Action
    public void doImport() {
        this.statusMessageLabel.setText("Importing...");
        this.fc.setDialogTitle("Import Actionmaps");
        this.fc.setCurrentDirectory(this.profileDir);
        int fcVal = this.fc.showOpenDialog(this.mainPanel);
        if (fcVal == 0) {
            File file = this.fc.getSelectedFile();
            this.doBackup();
            if (!ActionMaps.validateActionMaps(file)) {
                this.statusMessageLabel.setText("Not a valid ActionMaps file: " + file.getAbsolutePath());
                URL imgURL = this.getClass().getResource("resources/conflict.png");
                ImageIcon icon = new ImageIcon(imgURL);
                JOptionPane.showMessageDialog(this.getFrame(), "Not a valid ActionMaps file: '" + file.getAbsolutePath() + "'", "Error Importing Actionmaps!", 2, icon);
                return;
            }
            File actionmapsFile = this.workingFile.getFile();
            try {
                FileCopy.copy(file.getAbsolutePath(), actionmapsFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.statusMessageLabel.setText("Error Importing!");
                return;
            }
            this.doOpen(this.workingFile);
            this.statusMessageLabel.setText("Imported from " + file.getAbsolutePath());
        }
    }

    public void doSave() {
        if (this.workingFile != null) {
            this.doBackup();
            this.statusMessageLabel.setText("Saving...");
            ActionMaps.exportActionMaps(this.workingFile.getFile());
            this.workingJoyCfg.exportJoystickCfg(this.getJoystickCfgFile(this.workingFile, true));
            this.autoexecModel.exportAutoexecCfg();
            this.workingLastModified = this.workingFile.lastModified();
            this.statusMessageLabel.setText("Finished saving " + this.workingFile.getFile().getName() + ".");
            this.setAllActionSelectionsNotModified();
        }
    }

    private void doBackup() {
        if (this.workingFile != null && !this.workingHasBackup) {
            File currentActionmapsFile = this.workingFile.getFile();
            File backupDir = new File(this.profileDir, "backup");
            if (!backupDir.exists()) {
                backupDir.mkdir();
            }
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            File backupActionmapsFile = new File(backupDir, "actionmaps_" + timeStamp + ".xml");
            try {
                FileCopy.copy(currentActionmapsFile.getAbsolutePath(), backupActionmapsFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.workingHasBackup = true;
        }
    }

    public void doOpen(ActionmapsFileModel.ActionmapsFile actionmapsFile) {
        if (actionmapsFile != null) {
            this.workingJoyCfg = new JoystickCfgModel();
            this.workingJoyCfg.importJoystickCfgFile(this.getJoystickCfgFile(actionmapsFile, false));
            this.joyPanel.reloadSettings();
            this.workingFile = actionmapsFile;
            this.workingLastModified = actionmapsFile.lastModified();
            this.workingHasBackup = false;
            this.statusMessageLabel.setText("Loading...");
            ActionMaps.importActionMaps(this.workingFile.getFile());
            this.statusMessageLabel.setText("Successfully loaded " + this.workingFile.getFile().getName() + ".");
            this.performAllConflictChecks();
            this.setAllActionSelectionsNotModified();
            this.updateActionTableBinds();
            this.deselectAllActions();
            if (this.workingHasMissingActions) {
                URL imgURL = this.getClass().getResource("resources/question-big.png");
                ImageIcon icon = new ImageIcon(imgURL);
                JOptionPane.showMessageDialog(this.getFrame(), "At least one action was not detected in the selected actionmaps file: '" + this.workingFile.toString() + "'\nThese missing actions will be highlighted and placed next to a '?' icon.\n\nYou will be unable to configure any actions determined to be missing.\n        Note: Use the 'File -> New Actionmaps' menu option to have an actionmaps created\n        that has all necessary actions present.\n\n", "Missing actions detected!", 2, icon);
            }
        }
    }

    private File getJoystickCfgFile(ActionmapsFileModel.ActionmapsFile actionmapsFile, boolean saveFlag) {
        if (actionmapsFile == null) {
            return null;
        }
        File joyCfgFile = new File(actionmapsFile.getFile().getParentFile(), "joystick.cfg");
        if (!saveFlag && !joyCfgFile.exists()) {
            JoystickCfgModel newDefaultJoyCfg = new JoystickCfgModel();
            newDefaultJoyCfg.importJoystickCfgDefault();
            newDefaultJoyCfg.exportJoystickCfg(joyCfgFile);
        }
        return joyCfgFile;
    }

    @Action
    public void doNew() {
        TemplatesDialog dialog = new TemplatesDialog((Frame)this.getFrame(), true);
        dialog.showTemplateSelection();
        if (dialog.templateSelection == null) {
            this.statusMessageLabel.setText("Canceled creating new actionmaps from template.");
            return;
        }
        ActionmapsFileModel.ActionmapsFile actionmaps = new ActionmapsFileModel.ActionmapsFile(new File(this.profileDir, ActionmapsFileModel.getActionmapFilename()));
        try {
            this.statusMessageLabel.setText("Creating new actionmaps from template...");
            ActionMaps.importActionMaps(dialog.templateSelection.getFile());
            this.statusMessageLabel.setText("New actionmaps created from template.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusMessageLabel.setText("Error creating new actionmaps (could not read resource)!");
            return;
        }
        this.workingJoyCfg = new JoystickCfgModel();
        this.workingJoyCfg.importJoystickCfgDefault();
        this.joyPanel.reloadSettings();
        this.workingFile = actionmaps;
        this.workingLastModified = actionmaps.lastModified();
        this.workingHasBackup = false;
        this.doSave();
        this.performAllConflictChecks();
        this.setAllActionSelectionsNotModified();
        this.updateActionTableBinds();
        this.deselectAllActions();
    }

    public static void setStatusLabel(String label) {
        MWLLActionmapperView.reference.statusMessageLabel.setText(label);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MWLLActionmapperApp.getApplication().getMainFrame();
            this.aboutBox = new MWLLActionmapperAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MWLLActionmapperApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void doSelectProfile() {
        this.doSelectProfile(false);
    }

    public void doSelectProfile(boolean isFirstSelect) {
        List<File> profiles = ActionmapsFileModel.getMWLLProfiles();
        if (profiles.isEmpty()) {
            this.profileDir = null;
            JOptionPane.showMessageDialog(this.getFrame(), "No profiles found in My Documents\\" + ActionmapsFileModel.MWLL_PROFILES_LOCATION + ".\n\nYou must create a new Profile in Crysis before using this application.\n", "No profiles found, exiting!", 0);
            System.exit(0);
        } else if (profiles.size() == 1) {
            this.profileDir = profiles.get(0);
        } else {
            Object selection;
            int i;
            Object[] profileArray = new Object[profiles.size()];
            String paramSelectProfile = null;
            String preSelectProfile = null;
            if (MWLLActionmapperApp.args != null && MWLLActionmapperApp.args.length > 0) {
                for (i = 0; i < MWLLActionmapperApp.args.length; ++i) {
                    String argStr = MWLLActionmapperApp.args[i];
                    if (!argStr.startsWith("-profile")) continue;
                    paramSelectProfile = argStr.substring(argStr.indexOf("=") + 1).replaceAll("\"", "");
                    MWLLActionmapperApp.args[i] = "";
                }
            }
            if (isFirstSelect && paramSelectProfile == null) {
                paramSelectProfile = ActionmapperProperties.getLastUsedProfile();
            }
            for (i = 0; i < profiles.size(); ++i) {
                String profileName = profiles.get(i).getName();
                if (!profileName.equals(paramSelectProfile)) continue;
                preSelectProfile = profileName;
                break;
            }
            if (preSelectProfile == null) {
                String selectedProfile = null;
                for (int i2 = 0; i2 < profiles.size(); ++i2) {
                    profileArray[i2] = profiles.get(i2).getName();
                    if (!profiles.get(i2).equals(this.profileDir)) continue;
                    selectedProfile = profiles.get(i2).getName();
                }
                selection = JOptionPane.showInputDialog(this.getFrame(), "Please choose a profile.", "Select a profile", 3, null, profileArray, selectedProfile);
            } else {
                selection = preSelectProfile;
            }
            if (selection instanceof String) {
                String selStr = (String)selection;
                for (File thisProfile : profiles) {
                    if (!selStr.equals(thisProfile.getName())) continue;
                    this.profileDir = thisProfile;
                    break;
                }
                ActionmapperProperties.setLastUsedProfile(selStr);
            }
            if (this.profileDir == null) {
                System.exit(0);
            }
        }
        this.doOpen(new ActionmapsFileModel.ActionmapsFile(new File(this.profileDir, ActionmapsFileModel.getActionmapFilename())));
    }

    private void updateActionTableBinds() {
        this.playerPanel.updateActionTableBinds();
        this.vehiclePanel.updateActionTableBinds();
        this.mechPanel.updateActionTableBinds();
        this.tankPanel.updateActionTableBinds();
        this.vtolPanel.updateActionTableBinds();
        this.aerospacePanel.updateActionTableBinds();
    }

    private void deselectAllActions() {
        this.playerPanel.deselectAction();
        this.vehiclePanel.deselectAction();
        this.mechPanel.deselectAction();
        this.tankPanel.deselectAction();
        this.vtolPanel.deselectAction();
        this.aerospacePanel.deselectAction();
    }

    public void setWorkingFileModified(boolean modified) {
        if (this.workingFile != null) {
            String titleStr = null;
            if (modified) {
                long lastModified = this.workingFile.lastModified();
                if (this.workingLastModified != lastModified) {
                    int response = JOptionPane.showConfirmDialog(this.getFrame(), "The actionmaps file currently being edited has been modified outside of this application.\n\nWould you like to revert any recently made changes and open the new version on disk?\n    - Press 'Yes' to open the new version on disk.\n    - Press 'No' to continue and ignore changes on disk.\n\n", "Actionmaps file modified outside of this application, revert changes and open?", 0, 2);
                    this.workingLastModified = lastModified;
                    if (response == 0) {
                        this.setWorkingFileModified(false);
                        this.doOpen(this.workingFile);
                        return;
                    }
                }
                this.doSave();
            }
            titleStr = "MWLL Actionmapper - " + this.profileDir.getName();
            this.getFrame().setTitle(titleStr);
        }
    }

    private void setAllActionSelectionsNotModified() {
        this.setWorkingFileModified(false);
    }

    private void performAllConflictChecks() {
        this.setWorkingHasMissingActions(false);
        ActionModel.performConflictCheck();
    }

    public List<ActionPanel> getActionPanelList() {
        ArrayList<ActionPanel> panelList = new ArrayList<ActionPanel>();
        panelList.add(this.playerPanel.getActionPanel());
        panelList.add(this.vehiclePanel.getActionPanel());
        panelList.add(this.mechPanel.getActionPanel());
        panelList.add(this.tankPanel.getActionPanel());
        panelList.add(this.vtolPanel.getActionPanel());
        panelList.add(this.aerospacePanel.getActionPanel());
        return panelList;
    }

    public void setWorkingHasMissingActions(boolean workingHasMissingActions) {
        this.workingHasMissingActions = workingHasMissingActions;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.toolbarPanel = new JPanel();
        this.mainTabbedPane = new JTabbedPane();
        this.changeNoticeLabel = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.switchProfileItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.newMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.guideMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.popMenu = new JPopupMenu();
        this.activeMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.dupeMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.deleteMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.toolbarPanel.setName("toolbarPanel");
        GroupLayout toolbarPanelLayout = new GroupLayout(this.toolbarPanel);
        this.toolbarPanel.setLayout(toolbarPanelLayout);
        toolbarPanelLayout.setHorizontalGroup(toolbarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 511, Short.MAX_VALUE));
        toolbarPanelLayout.setVerticalGroup(toolbarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.mainTabbedPane.setName("mainTabbedPane");
        ResourceMap resourceMap = Application.getInstance(MWLLActionmapperApp.class).getContext().getResourceMap(MWLLActionmapperView.class);
        this.changeNoticeLabel.setFont(resourceMap.getFont("changeNoticeLabel.font"));
        this.changeNoticeLabel.setIcon(resourceMap.getIcon("changeNoticeLabel.icon"));
        this.changeNoticeLabel.setText(resourceMap.getString("changeNoticeLabel.text", new Object[0]));
        this.changeNoticeLabel.setToolTipText(resourceMap.getString("changeNoticeLabel.toolTipText", new Object[0]));
        this.changeNoticeLabel.setName("changeNoticeLabel");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.changeNoticeLabel).addContainerGap(515, Short.MAX_VALUE)).addComponent(this.mainTabbedPane, -1, 858, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGap(347, 347, 347).addComponent(this.toolbarPanel, -1, -1, Short.MAX_VALUE)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changeNoticeLabel, -1, 32, Short.MAX_VALUE).addComponent(this.toolbarPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainTabbedPane, -1, 484, Short.MAX_VALUE)));
        this.menuBar.setBackground(resourceMap.getColor("menuBar.background"));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(MWLLActionmapperApp.class).getContext().getActionMap(MWLLActionmapperView.class, this);
        this.switchProfileItem.setAction(actionMap.get("doSelectProfile"));
        this.switchProfileItem.setText(resourceMap.getString("switchProfileItem.text", new Object[0]));
        this.switchProfileItem.setName("switchProfileItem");
        fileMenu.add(this.switchProfileItem);
        this.jSeparator3.setName("jSeparator3");
        fileMenu.add(this.jSeparator3);
        this.newMenuItem.setAction(actionMap.get("doNew"));
        this.newMenuItem.setText(resourceMap.getString("newMenuItem.text", new Object[0]));
        this.newMenuItem.setName("newMenuItem");
        fileMenu.add(this.newMenuItem);
        this.importMenuItem.setAction(actionMap.get("doImport"));
        this.importMenuItem.setText(resourceMap.getString("importMenuItem.text", new Object[0]));
        this.importMenuItem.setName("importMenuItem");
        fileMenu.add(this.importMenuItem);
        this.exportMenuItem.setAction(actionMap.get("doExport"));
        this.exportMenuItem.setText(resourceMap.getString("exportMenuItem.text", new Object[0]));
        this.exportMenuItem.setName("exportMenuItem");
        fileMenu.add(this.exportMenuItem);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.guideMenuItem.setForeground(resourceMap.getColor("guideMenuItem.foreground"));
        this.guideMenuItem.setText(resourceMap.getString("guideMenuItem.text", new Object[0]));
        this.guideMenuItem.setToolTipText(resourceMap.getString("guideMenuItem.toolTipText", new Object[0]));
        this.guideMenuItem.setBorder(null);
        this.guideMenuItem.setName("guideMenuItem");
        this.guideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MWLLActionmapperView.this.guideMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(this.guideMenuItem);
        this.jSeparator5.setName("jSeparator5");
        helpMenu.add(this.jSeparator5);
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 858, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 688, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.popMenu.setName("popMenu");
        this.activeMenuItem.setAction(actionMap.get("setActive"));
        this.activeMenuItem.setIcon(resourceMap.getIcon("activeMenuItem.icon"));
        this.activeMenuItem.setText(resourceMap.getString("activeMenuItem.text", new Object[0]));
        this.activeMenuItem.setName("activeMenuItem");
        this.popMenu.add(this.activeMenuItem);
        this.jSeparator4.setName("jSeparator4");
        this.popMenu.add(this.jSeparator4);
        this.dupeMenuItem.setAction(actionMap.get("doDuplicate"));
        this.dupeMenuItem.setText(resourceMap.getString("dupeMenuItem.text", new Object[0]));
        this.dupeMenuItem.setName("dupeMenuItem");
        this.popMenu.add(this.dupeMenuItem);
        this.renameMenuItem.setAction(actionMap.get("doRename"));
        this.renameMenuItem.setText(resourceMap.getString("renameMenuItem.text", new Object[0]));
        this.renameMenuItem.setName("renameMenuItem");
        this.popMenu.add(this.renameMenuItem);
        this.jSeparator2.setName("jSeparator2");
        this.popMenu.add(this.jSeparator2);
        this.deleteMenuItem.setAction(actionMap.get("doDelete"));
        this.deleteMenuItem.setText(resourceMap.getString("deleteMenuItem.text", new Object[0]));
        this.deleteMenuItem.setName("deleteMenuItem");
        this.popMenu.add(this.deleteMenuItem);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void guideMenuItemActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://wiki.mechlivinglegends.net/index.php?title=Actionmapper_Guide"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initPanels() {
        this.playerPanel = new MappingPanel(MappingPanel.PanelType.PLAYER);
        this.vehiclePanel = new MappingPanel(MappingPanel.PanelType.VEHICLE);
        this.mechPanel = new MappingPanel(MappingPanel.PanelType.MECH);
        this.tankPanel = new MappingPanel(MappingPanel.PanelType.TANK);
        this.vtolPanel = new MappingPanel(MappingPanel.PanelType.VTOL);
        this.aerospacePanel = new MappingPanel(MappingPanel.PanelType.AEROSPACE);
        this.joyPanel = new JoystickCfgPanel();
        this.mainTabbedPane.add("Player", this.playerPanel);
        this.mainTabbedPane.add("Vehicle", this.vehiclePanel);
        this.mainTabbedPane.add("Mech", this.mechPanel);
        this.mainTabbedPane.add("Tank", this.tankPanel);
        this.mainTabbedPane.add("VTOL", this.vtolPanel);
        this.mainTabbedPane.add("Aerospace", this.aerospacePanel);
        this.mainTabbedPane.add("Joystick Settings", this.joyPanel);
        this.mainTabbedPane.setSelectedComponent(this.playerPanel);
    }

    public void setTabConflictStatus(MappingPanel.PanelType panelType, boolean hasConflict) {
        if (panelType == null) {
            return;
        }
        ImageIcon icon = null;
        if (hasConflict) {
            URL imgURL = this.getClass().getResource("resources/conflict.png");
            icon = new ImageIcon(imgURL);
        }
        int tabIndex = -1;
        block0: for (ActionPanel panel : this.getActionPanelList()) {
            if (panel.getPanelType() != panelType) continue;
            for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
                Component c = this.mainTabbedPane.getComponentAt(i);
                if (!(c instanceof MappingPanel) || ((MappingPanel)c).getActionPanel().getPanelType() != panel.getPanelType()) continue;
                tabIndex = i;
                continue block0;
            }
        }
        if (tabIndex >= 0) {
            this.mainTabbedPane.setIconAt(tabIndex, icon);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        ActionmapperProperties.saveActionmapperProperties();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

