/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.ActionPanel;
import mwllactionmapper.ActionTableModel;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.MappingPanel;

public class ActionModel {
    private static Properties actionModelProperties;
    private static boolean isCrysisRunning;
    public static final String[] defaultActions;
    public static final String[] multiplayerActions;
    public static final String[] startStopActions;
    public static final String[] toggleModeActions;
    public static final List<List<String>> ignoreConflictActionGroups;

    public static boolean isCrysisRunning() {
        return isCrysisRunning;
    }

    public static void setCrysisRunning(boolean running) {
        isCrysisRunning = running;
    }

    public static void loadProperties() {
        if (actionModelProperties != null) {
            return;
        }
        actionModelProperties = new Properties();
        try {
            actionModelProperties.load(MWLLActionmapperView.reference.getClass().getResourceAsStream("resources/ActionModel.properties"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getProperty(String key) {
        if (actionModelProperties == null) {
            return null;
        }
        return actionModelProperties.getProperty(key);
    }

    public static boolean isIgnoreConflictActions(String actionName1, String actionName2) {
        if (actionName1 == null || actionName2 == null) {
            return false;
        }
        for (int i = 0; i < ignoreConflictActionGroups.size(); ++i) {
            List<String> thisGroup = ignoreConflictActionGroups.get(i);
            if (!thisGroup.contains(actionName1) || !thisGroup.contains(actionName2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToggleModeAction(String actionName) {
        if (actionName == null) {
            return false;
        }
        for (String chkAction : toggleModeActions) {
            if (!chkAction.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStartStopAction(String actionName) {
        if (actionName == null) {
            return false;
        }
        for (String chkAction : startStopActions) {
            if (!chkAction.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefaultAction(String actionName) {
        if (actionName == null) {
            return false;
        }
        for (String chkAction : defaultActions) {
            if (!chkAction.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultiplayerAction(String actionName) {
        if (actionName == null) {
            return false;
        }
        for (String chkAction : multiplayerActions) {
            if (!chkAction.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    private static void addCategoryRow(String categoryName, ActionTableModel model, boolean preSeparator) {
        if (model == null || categoryName == null) {
            return;
        }
        if (preSeparator) {
            ActionModel.addSeparatorRow(model);
        }
        model.addRow(new ActionPanel.ActionSelection(categoryName));
    }

    private static void addSeparatorRow(ActionTableModel model) {
        if (model == null) {
            return;
        }
        model.addRow(new ActionPanel.ActionSelection(null));
    }

    public static ActionTableModel populatePlayerActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Movement", model, false);
        model.addRow(new ActionPanel.ActionSelection("Aim left/right", "rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Aim up/down", "rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Move forward/backward", "xi_movey", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Move forward", "moveforward", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Move backward", "moveback", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Strafe left/right", "xi_movex", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Strafe left", "moveleft", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Strafe right", "moveright", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Aim left/right", "xi_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Aim up/down", "xi_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        ActionModel.addCategoryRow("Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Use / Get in / Eject", "use", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Use / Get in / Eject", "xi_use", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Crouch", "crouch", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Sprint", "sprint", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Jump", "jump", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Rotate suit left", "leanleft", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Rotate suit right", "leanright", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        ActionModel.addCategoryRow("Weapons", model, true);
        model.addRow(new ActionPanel.ActionSelection("Fire weapon", "attack1", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Select main weapon", "medium", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Select next weapon", "nextitem", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Select previous weapon", "previtem", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Select rocket", "explosive", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Throw grenade", "grenade", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Throw grenade", "xi_grenade", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Change grenade", "handgrenade", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("(X) Change grenade", "xi_handgrenade", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Drop weapon", "drop", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        ActionModel.addCategoryRow("Equipment", model, true);
        model.addRow(new ActionPanel.ActionSelection("Toggle night vision", "hud_night_vision", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Toggle zoom", "zoom", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("(X) Toggle zoom", "xi_zoom", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Toggle lights", "lights", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        ActionModel.addCategoryRow("Targeting", model, true);
        model.addRow(new ActionPanel.ActionSelection("Toggle radar active/passive", "toggle_radar_mode", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target reticle", "track_reticule", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target nearest enemy", "track_nearest_enemy", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target next enemy", "track_next_enemy", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target previous enemy", "track_previous_enemy", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target nearest friendly", "track_nearest_friendly", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target next friendly", "track_next_friendly", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Target previous friendly", "track_previous_friendly", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        ActionModel.addCategoryRow("HUD", model, true);
        model.addRow(new ActionPanel.ActionSelection("Show Objectives", "objectives", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Show map", "hud_show_pda_map", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Show buy menu", "hud_buy_weapons", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Auto buy ammo", "buyammo", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Show Scoreboard", "hud_show_multiplayer_scoreboard", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("C-bill Button", "givemecbills", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Toggle C-bill donation menu", "Toggle_CBill_Menu", false, false, ActionPanel.ActionSelection.SCOPE.PLAYER));
        model.addRow(new ActionPanel.ActionSelection("Confirm C-bill donation", "Confirm_CBill_Menu", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Choose C-bill amount", "Choose_CBill_Amount", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Choose C-bill player", "Choose_CBill_Player", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Next C-bill menu option", "Next_CBill_Option", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Prev C-bill menu option", "Prev_CBill_Option", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        ActionModel.addCategoryRow("Spectating", model, true);
        model.addRow(new ActionPanel.ActionSelection("Spectator Minimum mode", "toggleIntCvar hud_spec_minimumMode", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Cycle spectator mode", "cycle_spectator_mode", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Next spectator target", "next_spectator_target", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Previous spectator target", "prev_spectator_target", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Move spectator up", "specmoveup", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Move spectator down", "specmovedown", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Move spectator up/down", "specmovez", true, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        ActionModel.addCategoryRow("Communication", model, true);
        model.addRow(new ActionPanel.ActionSelection("Chat", "hud_openchat", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Team chat", "hud_openteamchat", false, false, ActionPanel.ActionSelection.SCOPE.GLOBAL));
        model.addRow(new ActionPanel.ActionSelection("Radio Menu 1", "radio_group_0", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Radio Menu 2", "radio_group_1", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Radio Menu 3", "radio_group_2", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Radio Menu 4", "radio_group_3", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Select 1", "hud_select1", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Select 2", "hud_select2", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Select 3", "hud_select3", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Select 4", "hud_select4", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        model.addRow(new ActionPanel.ActionSelection("Select 5", "hud_select5", false, false, ActionPanel.ActionSelection.SCOPE.SPECTATOR));
        return model;
    }

    public static ActionTableModel populateVehicleActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Throttle", model, false);
        model.addRow(new ActionPanel.ActionSelection("Enable throttle axis", "EnableThrottleval", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle value", "SetThrottleval", true, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Throttle stop (Brake)", "v_brake", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        ActionModel.addCategoryRow("Motion Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Center torso/turret", "CenterTorso", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("MASC / Boost", "v_boost", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Reverse throttle", "SetThrottleReverse", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        ActionModel.addCategoryRow("Weapons", model, true);
        model.addRow(new ActionPanel.ActionSelection("Toggle group fire", "firemode", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire current group", "Fire_Current_Group", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 1", "Fire_Group1", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 2", "Fire_Group2", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 3", "Fire_Group3", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 4", "Fire_Group4", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 5", "Fire_Group5", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Fire group 6", "Fire_Group6", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire current group", "XI_Fire_Current_Group", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 1", "XI_Fire_Group1", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 2", "XI_Fire_Group2", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 3", "XI_Fire_Group3", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 4", "XI_Fire_Group4", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 5", "XI_Fire_Group5", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("(X) Fire group 6", "XI_Fire_Group6", false, true, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Toggle Weapon Grouping", "Toggle_Weapon", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Next Weapon", "Next_Weapon", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Previous Weapon", "Previous_Weapon", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Next Weapon Group", "Next_Weapon_Group", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Previous Weapon Group", "Previous_Weapon_Group", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        ActionModel.addCategoryRow("Core Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Powerup/shutdown", "Toggle_Powerup_Shutdown", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Override auto shutdown", "Toggle_Auto_Shutdown", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Flush coolant", "Flush_Coolant", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        ActionModel.addCategoryRow("HUD", model, true);
        model.addRow(new ActionPanel.ActionSelection("Next Vehicle Info", "next_vehicle_info", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Previous Vehicle Info", "previous_vehicle_info", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Sell Vehicle", "sell", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("C-bill Button", "givemecbills", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Toggle C-bill donation menu", "Toggle_CBill_Menu", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Confirm C-bill donation", "Confirm_CBill_Menu", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Choose C-bill amount", "Choose_CBill_Amount", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Choose C-bill player", "Choose_CBill_Player", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Next C-bill option", "Next_CBill_Option", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        model.addRow(new ActionPanel.ActionSelection("Prev C-bill option", "Prev_CBill_Option", false, false, ActionPanel.ActionSelection.SCOPE.CBILL_MENU));
        ActionModel.addCategoryRow("Throttle Extended Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Set throttle 0%", "SetThrottle0", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 10%", "SetThrottle1", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 20%", "SetThrottle2", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 30%", "SetThrottle3", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 40%", "SetThrottle4", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 50%", "SetThrottle5", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 60%", "SetThrottle6", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 70%", "SetThrottle7", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 80%", "SetThrottle8", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 90%", "SetThrottle9", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Set throttle 100%", "SetThrottle10", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        model.addRow(new ActionPanel.ActionSelection("Toggle ramping/instant throttle", "Toggle_Ramping_Throttle", false, false, ActionPanel.ActionSelection.SCOPE.VEHICLE));
        return model;
    }

    public static ActionTableModel populateMechActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Aiming", model, false);
        model.addRow(new ActionPanel.ActionSelection("Free reticle", "toggle_free_reticle", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Center reticle", "center_free_reticle", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Toggle independent reticle", "toggleIntCvar cl_free_reticle_independent", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        ActionModel.addCategoryRow("Movement", model, true);
        model.addRow(new ActionPanel.ActionSelection("Torso twist left/right", "v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Torso aim up/down", "v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("(X) Torso twist left/right", "xi_v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("(X) Torso aim up/down", "xi_v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("(X) Turn chassis left/right", "xi_v_movex", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Turn left", "v_turnleft", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Turn right", "v_turnright", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        ActionModel.addCategoryRow("Throttle", model, true);
        model.addRow(new ActionPanel.ActionSelection("Increase throttle", "v_moveforward", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Decrease throttle", "v_moveback", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Set throttle value", "SetThrottleval", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("(X) Move chassis forward/back", "xi_v_movey", true, false, ActionPanel.ActionSelection.SCOPE.MECH));
        ActionModel.addCategoryRow("Motion Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Crouch", "v_crouch", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        model.addRow(new ActionPanel.ActionSelection("Jump jets", "jump_jets", false, false, ActionPanel.ActionSelection.SCOPE.MECH));
        return model;
    }

    public static ActionTableModel populateTankActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Movement", model, false);
        model.addRow(new ActionPanel.ActionSelection("Turret turn left/right", "v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("Turret aim up/down", "v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("(X) Turret twist left/right", "xi_v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("(X) Turret aim up/down", "xi_v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("(X) Turn chassis left/right", "xi_v_movex", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("Turn left", "v_turnleft", false, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("Turn right", "v_turnright", false, false, ActionPanel.ActionSelection.SCOPE.TANK));
        ActionModel.addCategoryRow("Throttle", model, true);
        model.addRow(new ActionPanel.ActionSelection("Move forward", "v_moveforward", false, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("Move backward", "v_moveback", false, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("Set throttle value", "SetThrottleval", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        model.addRow(new ActionPanel.ActionSelection("(X) Move chassis forward/back", "xi_v_movey", true, false, ActionPanel.ActionSelection.SCOPE.TANK));
        ActionModel.addCategoryRow("Motion Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Deploy", "deploy", false, false, ActionPanel.ActionSelection.SCOPE.TANK));
        return model;
    }

    public static ActionTableModel populateVtolActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Pitch", model, false);
        model.addRow(new ActionPanel.ActionSelection("Pitch up/down", "v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("(X) Pitch up/down", "xi_v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Pitch up", "v_pitchup", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Pitch down", "v_pitchdown", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Pitch", "v_invertVTOLPitchControl"));
        ActionModel.addCategoryRow("Turn", model, true);
        model.addRow(new ActionPanel.ActionSelection("Turn left/right", "v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("(X) Turn left/right", "xi_v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Turn left", "v_turnleft", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Turn right", "v_turnright", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Yaw (turn)", "v_invertVTOLYawControl"));
        ActionModel.addCategoryRow("Rotate/Roll", model, true);
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll left/right", "v_rotateroll", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("(X) Roll left/right", "xi_v_movex", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll left", "v_rollleft", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll right", "v_rollright", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Roll", "v_invertVTOLRollControl"));
        ActionModel.addCategoryRow("Throttle/Vertical Move", model, true);
        model.addRow(new ActionPanel.ActionSelection("Set throttle value", "SetThrottleval", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("(X) Throttle (Move up/down)", "xi_v_movey", true, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Move up", "v_moveup", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Move down", "v_movedown", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        ActionModel.addCategoryRow("Motion Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Level out", "levelout", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        model.addRow(new ActionPanel.ActionSelection("Toggle Landing Gears", "ToggleGears", false, false, ActionPanel.ActionSelection.SCOPE.VTOL));
        return model;
    }

    public static ActionTableModel populateAerospaceActions() {
        ActionTableModel model = new ActionTableModel();
        ActionModel.addCategoryRow("Pitch", model, false);
        model.addRow(new ActionPanel.ActionSelection("Pitch up/down", "v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("(X) Pitch up/down", "xi_v_rotatepitch", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Pitch up", "v_pitchup", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Pitch down", "v_pitchdown", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Pitch", "v_invertAeroPitchControl"));
        ActionModel.addCategoryRow("Turn", model, true);
        model.addRow(new ActionPanel.ActionSelection("Turn left/right", "v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("(X) Turn left/right", "xi_v_rotateyaw", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Turn left", "v_turnleft", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Turn right", "v_turnright", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Yaw (turn)", "v_invertAeroYawControl"));
        ActionModel.addCategoryRow("Rotate/Roll", model, true);
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll left/right", "v_rotateroll", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("(X) Roll left/right", "xi_v_movex", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll left", "v_rollleft", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Rotate/Roll right", "v_rollright", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(ActionPanel.ActionSelection.createAutoexecCvarAction("Invert Roll", "v_invertAeroRollControl"));
        ActionModel.addCategoryRow("Throttle", model, true);
        model.addRow(new ActionPanel.ActionSelection("Set throttle value", "SetThrottleval", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("(X) Throttle", "xi_v_movey", true, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Increase throttle", "v_moveup", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Decrease throttle", "v_movedown", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        ActionModel.addCategoryRow("Motion Actions", model, true);
        model.addRow(new ActionPanel.ActionSelection("Level out", "levelout", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        model.addRow(new ActionPanel.ActionSelection("Toggle Landing Gears", "ToggleGears", false, false, ActionPanel.ActionSelection.SCOPE.AERO));
        return model;
    }

    public static String getActionMapName(String actionName, MappingPanel.PanelType panelType) {
        String actionMapName = null;
        if (ActionModel.isDefaultAction(actionName)) {
            actionMapName = "default";
        } else if (ActionModel.isMultiplayerAction(actionName)) {
            actionMapName = "multiplayer";
        } else if (MappingPanel.PanelType.PLAYER == panelType) {
            actionMapName = "player";
        } else if (MappingPanel.PanelType.VEHICLE == panelType) {
            actionMapName = "vehicle";
        } else if (MappingPanel.PanelType.MECH == panelType) {
            actionMapName = "mech";
        } else if (MappingPanel.PanelType.TANK == panelType) {
            actionMapName = "tank";
        } else if (MappingPanel.PanelType.VTOL == panelType) {
            actionMapName = "vtol";
        } else if (MappingPanel.PanelType.AEROSPACE == panelType) {
            actionMapName = "aerospace";
        }
        return actionMapName;
    }

    public static List<String> getMirroredActionNames(String actionName) {
        ArrayList<String> mirrors = new ArrayList<String>();
        if (actionName == null) {
            return mirrors;
        }
        if (ActionModel.isStartStopAction(actionName)) {
            String stopActionName = actionName.startsWith("XI_") ? "XI_Stop_" + actionName.substring(3, actionName.length()) : "Stop_" + actionName;
            mirrors.add(stopActionName);
        } else if ("jump".equals(actionName)) {
            String jetActionName = "jump_jets";
            mirrors.add(jetActionName);
        }
        return mirrors;
    }

    public static void performConflictCheck() {
        HashMap<String, ActionSelectionMap> keyTable = new HashMap<String, ActionSelectionMap>();
        List<ActionPanel> actionPanelList = MWLLActionmapperView.reference.getActionPanelList();
        if (actionPanelList == null) {
            return;
        }
        for (ActionPanel actionPanel : actionPanelList) {
            JTable actionTable = actionPanel.getActionTable();
            if (actionTable == null) continue;
            MappingPanel.PanelType panelType = actionPanel.getPanelType();
            boolean hasConflict = false;
            DefaultTableModel model = (DefaultTableModel)actionTable.getModel();
            int numActions = model.getRowCount();
            if (numActions == 0 || model.getColumnCount() == 0) {
                return;
            }
            for (int i = 0; i < numActions; ++i) {
                ActionPanel.ActionSelection actionObj = (ActionPanel.ActionSelection)model.getValueAt(i, 0);
                if (actionObj.isCategoryHeader()) continue;
                actionObj.setHasConflict(false);
                actionObj.setConflictMessage(null);
                String actionName = actionObj.getActionName();
                String actionMapName = ActionModel.getActionMapName(actionName, panelType);
                List<String> keys = ActionMaps.getActionKeys(actionMapName, actionName);
                if (keys == null) {
                    if (actionObj.isOptional() || !actionObj.isAutoexecCvar()) continue;
                    continue;
                }
                actionObj.setIsMissing(false);
                for (String thisKey : keys) {
                    if (thisKey == null || thisKey.equals("null") || thisKey.length() == 0) continue;
                    String baseKey = thisKey.replaceFirst("inv", "").replaceFirst("raw", "");
                    boolean storeKey = false;
                    if (keyTable.containsKey(baseKey)) {
                        ActionSelectionMap conflictActionObjMap = (ActionSelectionMap)keyTable.get(baseKey);
                        ActionPanel.ActionSelection conflictActionObj = conflictActionObjMap.getActionSelection();
                        MappingPanel.PanelType conflictActionPanelType = conflictActionObjMap.getPanelType();
                        if (ActionModel.isIgnoreConflictActions(actionObj.getActionName(), conflictActionObj.getActionName())) {
                            storeKey = true;
                        } else if (conflictActionObj == actionObj) {
                            actionObj.setHasConflict(true);
                            actionObj.setConflictMessage(baseKey + ";Key is already assigned to this action.");
                            hasConflict = true;
                        } else if (actionObj.isInScope(conflictActionObj)) {
                            actionObj.setHasConflict(true);
                            actionObj.setConflictMessage(baseKey + ";Conflicts with '" + conflictActionObj.getDisplayName() + "' in " + conflictActionPanelType.toString() + ".");
                            conflictActionObj.setHasConflict(true);
                            conflictActionObj.setConflictMessage(baseKey + ";Conflicts with '" + actionObj.getDisplayName() + "' in " + panelType.toString() + ".");
                            hasConflict = true;
                        } else {
                            storeKey = true;
                        }
                    } else {
                        storeKey = true;
                    }
                    if (!storeKey) continue;
                    ActionSelectionMap actionObjMap = new ActionSelectionMap();
                    actionObjMap.setActionSelection(actionObj);
                    actionObjMap.setPanelType(panelType);
                    keyTable.put(baseKey, actionObjMap);
                }
            }
            MWLLActionmapperView.reference.setTabConflictStatus(panelType, hasConflict);
        }
        for (ActionPanel actionPanel : actionPanelList) {
            actionPanel.updateKeyConflictLabels();
            actionPanel.updateTableBindingColumnData();
            actionPanel.getActionTable().updateUI();
        }
    }

    public static List<String> getActionKeys(ActionPanel.ActionSelection actionObj, MappingPanel.PanelType panelType) {
        if (actionObj == null) {
            return null;
        }
        String actionName = actionObj.getActionName();
        String actionMapName = ActionModel.getActionMapName(actionName, panelType);
        List<String> keys = ActionMaps.getActionKeys(actionMapName, actionName);
        return keys;
    }

    static {
        isCrysisRunning = false;
        defaultActions = new String[]{"hud_night_vision", "hud_thermal_vision", "attack1", "zoom", "xi_zoom", "use", "xi_use", "buyammo", "hud_show_pda_map", "hud_buy_weapons", "hud_openteamchat", "hud_openchat", "voice_chat_talk", "toggle_radar_mode", "track_previous_enemy", "track_next_enemy", "track_nearest_enemy", "track_previous_friendly", "track_next_friendly", "track_nearest_friendly", "track_reticule", "cycle_spectator_mode", "prev_spectator_target", "next_spectator_target", "specmoveup", "specmovedown", "specmovez", "hud_show_multiplayer_scoreboard", "hud_hide_multiplayer_scoreboard", "objectives", "hud_select1", "hud_select2", "hud_select3", "hud_select4", "hud_select5"};
        multiplayerActions = new String[]{"radio_group_0", "radio_group_1", "radio_group_2", "radio_group_3"};
        startStopActions = new String[]{"Fire_Current_Group", "Fire_Group1", "Fire_Group2", "Fire_Group3", "Fire_Group4", "Fire_Group5", "Fire_Group6", "XI_Fire_Current_Group", "XI_Fire_Group1", "XI_Fire_Group2", "XI_Fire_Group3", "XI_Fire_Group4", "XI_Fire_Group5", "XI_Fire_Group6"};
        toggleModeActions = new String[]{"toggle_free_reticle"};
        ignoreConflictActionGroups = Arrays.asList(Arrays.asList("toggle_free_reticle", "center_free_reticle", "toggleIntCvar cl_free_reticle_independent"));
    }

    private static class ActionSelectionMap {
        private ActionPanel.ActionSelection actSel;
        private MappingPanel.PanelType panelType;

        private ActionSelectionMap() {
        }

        public ActionPanel.ActionSelection getActionSelection() {
            return this.actSel;
        }

        public void setActionSelection(ActionPanel.ActionSelection actSel) {
            this.actSel = actSel;
        }

        public MappingPanel.PanelType getPanelType() {
            return this.panelType;
        }

        public void setPanelType(MappingPanel.PanelType panelType) {
            this.panelType = panelType;
        }
    }
}

