/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.model.FileCopy;

public class ActionmapsFileModel {
    public static String MWLL_PROFILES_LOCATION;
    public static final String sep;
    public static final String ACTIONMAPS = "actionmaps";
    public static final String JOYSTICK = "joystick";
    public static final String ORIGINAL = "original";
    public static final String DEFAULT = "default";
    public static final String XML_EXTENSION = ".xml";
    public static final String CFG_EXTENSION = ".cfg";

    public static void init_MWLL_PROFILES_LOCATION() {
        MWLL_PROFILES_LOCATION = "My Games" + sep + "Crysis Wars" + sep + "Profiles";
    }

    public static ActionmapsFile performFirstTimeActionmapsOps(File profileDir) {
        ActionmapsFile actionmaps = null;
        if (profileDir == null) {
            return actionmaps;
        }
        File currentActionmapsFile = new File(profileDir, ActionmapsFileModel.getActionmapFilename());
        if (currentActionmapsFile.exists()) {
            File backupActionmapsFile = new File(profileDir, "actionmaps_original.xml");
            try {
                FileCopy.copy(currentActionmapsFile.getAbsolutePath(), backupActionmapsFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (backupActionmapsFile.exists()) {
                JOptionPane.showMessageDialog(MWLLActionmapperView.reference.getFrame(), "Since this appears to be the first time using Actionmapper for this profile\nthe orignal actionmaps has been backed up.", "First time original backup created", 1);
            }
        } else {
            ActionMaps.importActionMapsFromStream(MWLLActionmapperView.reference.getClass().getResourceAsStream("resources/actionmaps_default.xml"));
            ActionMaps.exportActionMaps(currentActionmapsFile);
            if (currentActionmapsFile.exists()) {
                JOptionPane.showMessageDialog(MWLLActionmapperView.reference.getFrame(), "Since this appears to be the first time using Actionmapper for this profile\na new default actionmaps has been created.", "First time default created", 1);
            }
        }
        return actionmaps;
    }

    public static File getMWLLDocumentsFolder() {
        File documentsFolder = new JFileChooser().getFileSystemView().getDefaultDirectory();
        try {
            File cryDoc = new File(documentsFolder + sep + MWLL_PROFILES_LOCATION);
            if (cryDoc.exists() && cryDoc.canRead()) {
                return cryDoc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<File> getMWLLProfiles() {
        File cryDocsFolder = ActionmapsFileModel.getMWLLDocumentsFolder();
        if (cryDocsFolder == null) {
            return new ArrayList<File>(0);
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] profileDirs = cryDocsFolder.listFiles(fileFilter);
        ArrayList<File> profiles = new ArrayList<File>(profileDirs.length);
        for (File thisProfile : profileDirs) {
            if (thisProfile.getName().equals(DEFAULT)) continue;
            profiles.add(thisProfile);
        }
        return profiles;
    }

    public static String getActionmapFilename() {
        return "actionmaps.xml";
    }

    static {
        sep = System.getProperties().getProperty("file.separator");
    }

    public static class ActionmapsFile {
        private File actionmaps;

        public long lastModified() {
            if (this.actionmaps != null) {
                return this.actionmaps.lastModified();
            }
            return 0L;
        }

        public ActionmapsFile(File actionmaps) {
            this.actionmaps = actionmaps;
        }

        public File getFile() {
            return this.actionmaps;
        }

        public String toString() {
            String str = "";
            if (this.actionmaps != null) {
                str = str + this.actionmaps.getName();
            }
            return str;
        }
    }
}

