/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileCopy {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java FileCopy <source file> <destination>");
        } else {
            try {
                FileCopy.copy(args[0], args[1]);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String from_name, String to_name) throws IOException {
        File from_file = new File(from_name);
        File to_file = new File(to_name);
        if (!from_file.exists()) {
            FileCopy.abort("FileCopy: no such source file: " + from_name);
        }
        if (!from_file.isFile()) {
            FileCopy.abort("FileCopy: can't copy directory: " + from_name);
        }
        if (!from_file.canRead()) {
            FileCopy.abort("FileCopy: source file is unreadable: " + from_name);
        }
        if (to_file.isDirectory()) {
            to_file = new File(to_file, from_file.getName());
        }
        if (to_file.exists()) {
            if (!to_file.canWrite()) {
                FileCopy.abort("FileCopy: destination file is unwriteable: " + to_name);
            }
        } else {
            File dir;
            String parent = to_file.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                FileCopy.abort("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                FileCopy.abort("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                FileCopy.abort("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytes_read;
            from = new FileInputStream(from_file);
            to = new FileOutputStream(to_file);
            byte[] buffer = new byte[4096];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void abort(String msg) throws IOException {
        throw new IOException(msg);
    }
}

