/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.JTextComponent;

public class BaseEditorPaneUI
extends BasicEditorPaneUI {
    private Border orgBorder = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseEditorPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.updateBackground();
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.getComponent().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (BaseEditorPaneUI.this.getComponent() != null) {
                        BaseEditorPaneUI.this.orgBorder = BaseEditorPaneUI.this.getComponent().getBorder();
                        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                        if (lookAndFeel instanceof AbstractLookAndFeel) {
                            Border border = ((AbstractLookAndFeel)lookAndFeel).getBorderFactory().getFocusFrameBorder();
                            BaseEditorPaneUI.this.getComponent().setBorder(border);
                        }
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (BaseEditorPaneUI.this.getComponent() != null) {
                        BaseEditorPaneUI.this.getComponent().setBorder(BaseEditorPaneUI.this.orgBorder);
                    }
                }
            });
        }
    }

    protected void paintBackground(Graphics graphics) {
        Color color = this.getComponent().getBackground();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            this.getComponent().setBackground(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        super.paintBackground(graphics);
        this.getComponent().setBackground(color);
    }

    private void updateBackground() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getBackground() instanceof UIResource) {
            if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
                jTextComponent.setBackground(AbstractLookAndFeel.getDisabledBackgroundColor());
            } else {
                jTextComponent.setBackground(AbstractLookAndFeel.getInputBackgroundColor());
            }
        }
    }
}

