/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;

public class BaseFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private Border orgBorder = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseFormattedTextFieldUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.getComponent().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null) {
                        BaseFormattedTextFieldUI.this.orgBorder = BaseFormattedTextFieldUI.this.getComponent().getBorder();
                        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                        if (lookAndFeel instanceof AbstractLookAndFeel) {
                            Border border = ((AbstractLookAndFeel)lookAndFeel).getBorderFactory().getFocusFrameBorder();
                            BaseFormattedTextFieldUI.this.getComponent().setBorder(border);
                        }
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null) {
                        BaseFormattedTextFieldUI.this.getComponent().setBorder(BaseFormattedTextFieldUI.this.orgBorder);
                    }
                }
            });
        }
    }

    protected void paintBackground(Graphics graphics) {
        Color color = this.getComponent().getBackground();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            this.getComponent().setBackground(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        super.paintBackground(graphics);
        this.getComponent().setBackground(color);
    }

    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(graphics);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }
}

