/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.ColorUIResource;

public class BaseIcons {
    private static Icon checkBoxIcon = null;
    private static Icon radioButtonIcon = null;
    private static Icon optionPaneErrorIcon = null;
    private static Icon optionPaneWarningIcon = null;
    private static Icon optionPaneInformationIcon = null;
    private static Icon optionPaneQuestionIcon = null;
    private static Icon fileChooserDetailViewIcon = null;
    private static Icon fileChooserHomeFolderIcon = null;
    private static Icon fileChooserListViewIcon = null;
    private static Icon fileChooserNewFolderIcon = null;
    private static Icon fileChooserUpFolderIcon = null;
    private static Icon treeComputerIcon = null;
    private static Icon treeFloppyDriveIcon = null;
    private static Icon treeHardDriveIcon = null;
    private static Icon treeFolderIcon = null;
    private static Icon treeLeafIcon = null;
    private static Icon treeOpenIcon = null;
    private static Icon treeClosedIcon = null;
    private static Icon paletteCloseIcon = null;
    private static Icon menuIcon = null;
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon upArrowIcon = null;
    private static Icon downArrowIcon = null;
    private static Icon leftArrowIcon = null;
    private static Icon rightArrowIcon = null;
    private static Icon splitterUpArrowIcon = null;
    private static Icon splitterDownArrowIcon = null;
    private static Icon splitterLeftArrowIcon = null;
    private static Icon splitterRightArrowIcon = null;
    private static Icon splitterHorBumpIcon = null;
    private static Icon splitterVerBumpIcon = null;
    private static Icon thumbHorIcon = null;
    private static Icon thumbVerIcon = null;
    private static Icon thumbHorIconRollover = null;
    private static Icon thumbVerIconRollover = null;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getOptionPaneErrorIcon() {
        if (optionPaneErrorIcon == null) {
            optionPaneErrorIcon = new LazyImageIcon("icons/Error.gif");
        }
        return optionPaneErrorIcon;
    }

    public static Icon getOptionPaneWarningIcon() {
        if (optionPaneWarningIcon == null) {
            optionPaneWarningIcon = new LazyImageIcon("icons/Warning.gif");
        }
        return optionPaneWarningIcon;
    }

    public static Icon getOptionPaneInformationIcon() {
        if (optionPaneInformationIcon == null) {
            optionPaneInformationIcon = new LazyImageIcon("icons/Inform.gif");
        }
        return optionPaneInformationIcon;
    }

    public static Icon getOptionPaneQuestionIcon() {
        if (optionPaneQuestionIcon == null) {
            optionPaneQuestionIcon = new LazyImageIcon("icons/Question.gif");
        }
        return optionPaneQuestionIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new LazyImageIcon("icons/DetailsView.gif");
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new LazyImageIcon("icons/Home.gif");
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new LazyImageIcon("icons/ListView.gif");
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new LazyImageIcon("icons/NewFolder.gif");
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new LazyImageIcon("icons/UpFolder.gif");
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new LazyImageIcon("icons/Computer.gif");
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new LazyImageIcon("icons/FloppyDrive.gif");
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new LazyImageIcon("icons/HardDrive.gif");
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        if (treeFolderIcon == null) {
            treeFolderIcon = new LazyImageIcon("icons/TreeClosed.gif");
        }
        return treeFolderIcon;
    }

    public static Icon getTreeLeafIcon() {
        if (treeLeafIcon == null) {
            treeLeafIcon = new LazyImageIcon("icons/TreeLeaf.gif");
        }
        return treeLeafIcon;
    }

    public static Icon getTreeControlIcon(boolean bl) {
        if (bl) {
            if (treeClosedIcon == null) {
                treeClosedIcon = new LazyImageIcon("icons/TreeClosedButton.gif");
            }
            return treeClosedIcon;
        }
        if (treeOpenIcon == null) {
            treeOpenIcon = new LazyImageIcon("icons/TreeOpenButton.gif");
        }
        return treeOpenIcon;
    }

    public static Icon getMenuIcon() {
        if (menuIcon == null) {
            menuIcon = new LazyImageIcon("icons/JavaCup.gif");
        }
        return menuIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getWindowIconColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
            iconIcon = new IconSymbol(colorUIResource, null, colorUIResource2);
        }
        return iconIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getWindowIconColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
            maxIcon = new MaxSymbol(colorUIResource, null, colorUIResource2);
        }
        return maxIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getWindowIconColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
            minIcon = new MinSymbol(colorUIResource, null, colorUIResource2);
        }
        return minIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getWindowIconColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
            closeIcon = new CloseSymbol(colorUIResource, null, colorUIResource2);
        }
        return closeIcon;
    }

    public static Icon getPaletteCloseIcon() {
        if (paletteCloseIcon == null) {
            paletteCloseIcon = new CloseSymbol(Color.black, null, Color.red);
        }
        return paletteCloseIcon;
    }

    public static Icon getMenuArrowIcon() {
        return BaseIcons.getRightArrowIcon();
    }

    public static Icon getMenuCheckBoxIcon() {
        return BaseIcons.getCheckBoxIcon();
    }

    public static Icon getMenuRadioButtonIcon() {
        return BaseIcons.getRadioButtonIcon();
    }

    public static Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = new LazyImageIcon("icons/UpArrow.gif");
        }
        return upArrowIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = new LazyImageIcon("icons/DownArrow.gif");
        }
        return downArrowIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = new LazyImageIcon("icons/LeftArrow.gif");
        }
        return leftArrowIcon;
    }

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = new LazyImageIcon("icons/RightArrow.gif");
        }
        return rightArrowIcon;
    }

    public static Icon getSplitterUpArrowIcon() {
        if (splitterUpArrowIcon == null) {
            splitterUpArrowIcon = new LazyImageIcon("icons/SplitterUpArrow.gif");
        }
        return splitterUpArrowIcon;
    }

    public static Icon getSplitterDownArrowIcon() {
        if (splitterDownArrowIcon == null) {
            splitterDownArrowIcon = new LazyImageIcon("icons/SplitterDownArrow.gif");
        }
        return splitterDownArrowIcon;
    }

    public static Icon getSplitterLeftArrowIcon() {
        if (splitterLeftArrowIcon == null) {
            splitterLeftArrowIcon = new LazyImageIcon("icons/SplitterLeftArrow.gif");
        }
        return splitterLeftArrowIcon;
    }

    public static Icon getSplitterRightArrowIcon() {
        if (splitterRightArrowIcon == null) {
            splitterRightArrowIcon = new LazyImageIcon("icons/SplitterRightArrow.gif");
        }
        return splitterRightArrowIcon;
    }

    public static Icon getSplitterHorBumpIcon() {
        if (splitterHorBumpIcon == null) {
            splitterHorBumpIcon = new LazyImageIcon("icons/SplitterHorBumps.gif");
        }
        return splitterHorBumpIcon;
    }

    public static Icon getSplitterVerBumpIcon() {
        if (splitterVerBumpIcon == null) {
            splitterVerBumpIcon = new LazyImageIcon("icons/SplitterVerBumps.gif");
        }
        return splitterVerBumpIcon;
    }

    public static Icon getComboBoxIcon() {
        return BaseIcons.getDownArrowIcon();
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = new LazyImageIcon("icons/thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = new LazyImageIcon("icons/thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new LazyImageIcon("icons/thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new LazyImageIcon("icons/thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    public static class CloseSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CloseSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
        }

        public CloseSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.insets = insets;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
        }

        public CloseSymbol(Color color, Color color2, Color color3, Color color4, Color color5, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color4;
            this.inactiveShadowColor = color5;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n4 = component.getWidth() - this.insets.left - this.insets.right;
            int n5 = component.getHeight() - this.insets.top - this.insets.bottom;
            boolean bl = JTattooUtilities.isActive((JComponent)component);
            Color color = this.foregroundColor;
            if (!bl) {
                color = this.inactiveForegroundColor;
            }
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n6 = n4 / 12 + 1;
            int n7 = n3 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(n6, 1, 2));
            if (this.shadowColor != null) {
                if (!bl) {
                    graphics2D.setColor(this.inactiveShadowColor);
                } else {
                    graphics2D.setColor(this.shadowColor);
                }
                graphics2D.drawLine(n3 + 1, n7 + 1, n4 - n3 + 1, n5 - n7 + 1);
                graphics2D.drawLine(n4 - n3 + 1, n7 + 1, n3 + 1, n5 - n7 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawLine(n3, n7, n4 - n3, n5 - n7);
            graphics2D.drawLine(n4 - n3, n7, n3, n5 - n7);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MinSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MinSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
        }

        public MinSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
            this.insets = insets;
        }

        public MinSymbol(Color color, Color color2, Color color3, Color color4, Color color5, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color4;
            this.inactiveShadowColor = color5;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n3 = component.getWidth() - this.insets.left - this.insets.right;
            int n4 = component.getHeight() - this.insets.top - this.insets.bottom;
            int n5 = Math.min(n3, n4);
            int n6 = 10;
            int n7 = 1;
            n6 = n5 < 14 ? 7 : (n5 < 18 ? 9 : (n5 < 22 ? 11 : (n5 < 26 ? 13 : 15)));
            n3 = Math.min(n3, n4);
            n4 = Math.min(n3, n4);
            n3 -= n6;
            n4 -= n6;
            n += n6 / 4 + 1;
            n2 += n6 / 4;
            boolean bl = JTattooUtilities.isActive((JComponent)component);
            Color color = this.foregroundColor;
            if (!bl) {
                color = this.inactiveForegroundColor;
            }
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n7, 0, 0));
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            int n8 = n + n6 / 2 - 2;
            int n9 = n + Math.max(n6 / 2 - 2, 2 * n7 + 1);
            area.subtract(new Area(new Rectangle2D.Double(n8, n9, n3, n4)));
            graphics2D.setClip(area);
            if (this.shadowColor != null) {
                if (!bl) {
                    graphics2D.setColor(this.inactiveShadowColor);
                } else {
                    graphics2D.setColor(this.shadowColor);
                }
                graphics2D.drawRect(n + 1, n2 + 1, n3, n4);
                graphics2D.drawLine(n + 1, n2 + n7 + 1, n + n3 + 1, n2 + n7 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.drawLine(n, n2 + n7, n + n3, n2 + n7);
            graphics2D.setClip(shape);
            n += n6 / 2 - 2;
            n2 += Math.max(n6 / 2 - 2, 2 * n7 + 1);
            if (this.shadowColor != null) {
                if (!bl) {
                    graphics2D.setColor(this.inactiveShadowColor);
                } else {
                    graphics2D.setColor(this.shadowColor);
                }
                graphics2D.drawRect(n + 1, n2 + 1, n3, n4);
                graphics2D.drawLine(n + 1, n2 + n7 + 1, n + n3 + 1, n2 + n7 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n, n2, n3, n4);
            graphics2D.drawLine(n, n2 + n7, n + n3, n2 + n7);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MaxSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MaxSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
        }

        public MaxSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
            this.insets = insets;
        }

        public MaxSymbol(Color color, Color color2, Color color3, Color color4, Color color5, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color4;
            this.inactiveShadowColor = color5;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n3 = component.getWidth() - this.insets.left - this.insets.right;
            int n4 = component.getHeight() - this.insets.top - this.insets.bottom;
            boolean bl = JTattooUtilities.isActive((JComponent)component);
            Color color = this.foregroundColor;
            if (!bl) {
                color = this.inactiveForegroundColor;
            }
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n5 = n3 / 12;
            int n6 = n3 / 5 + 2;
            int n7 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n5, 0, 0));
            if (this.shadowColor != null) {
                if (!bl) {
                    graphics2D.setColor(this.inactiveShadowColor);
                } else {
                    graphics2D.setColor(this.shadowColor);
                }
                graphics2D.drawRect(n6 + 1, n7 + 1, n3 - 2 * n6, n4 - 2 * n7);
                graphics2D.drawLine(n6 + 1, n7 + n5 + 1, n3 - n6, n7 + n5 + 1);
            }
            graphics2D.setColor(color);
            graphics2D.drawRect(n6, n7, n3 - 2 * n6, n4 - 2 * n7);
            graphics2D.drawLine(n6, n7 + n5, n3 - n6 - 1, n7 + n5);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class IconSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public IconSymbol(Color color, Color color2, Color color3) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
        }

        public IconSymbol(Color color, Color color2, Color color3, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color;
            this.inactiveShadowColor = color2;
            this.insets = insets;
        }

        public IconSymbol(Color color, Color color2, Color color3, Color color4, Color color5, Insets insets) {
            this.foregroundColor = color;
            this.shadowColor = color2;
            this.rolloverColor = color3;
            this.inactiveForegroundColor = color4;
            this.inactiveShadowColor = color5;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(this.insets.left, this.insets.top);
            int n4 = component.getWidth() - this.insets.left - this.insets.right;
            int n5 = component.getHeight() - this.insets.top - this.insets.bottom;
            boolean bl = JTattooUtilities.isActive((JComponent)component);
            Color color = this.foregroundColor;
            if (!bl) {
                color = this.inactiveForegroundColor;
            }
            if (component instanceof AbstractButton && ((AbstractButton)component).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int n6 = n4 / 12 + 1;
            int n7 = n3 = n4 / 5 + 2;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n6, 0, 0));
            if (this.shadowColor != null) {
                if (!bl) {
                    graphics2D.setColor(this.inactiveShadowColor);
                } else {
                    graphics2D.setColor(this.shadowColor);
                }
                graphics2D.drawLine(n3 + 1, n5 - n7, n4 - n3 + 1, n5 - n7);
            }
            graphics2D.setColor(color);
            graphics2D.drawLine(n3, n5 - n7 - 1, n4 - n3, n5 - n7 - 1);
            graphics2D.setStroke(stroke);
            graphics.translate(-this.insets.left, -this.insets.top);
        }
    }

    private static class RadioButtonIcon
    implements Icon {
        private static final Color MENU_ITEM_BACKGROUND = new Color(248, 248, 248);
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object;
            Object object2;
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new Ellipse2D.Double(n, n2, 15.0, 15.0));
            area2.intersect(area);
            graphics2D.setClip(area2);
            if (component instanceof JRadioButtonMenuItem) {
                graphics.setColor(MENU_ITEM_BACKGROUND);
                graphics.fillRect(n, n2, 14, 14);
            } else if (abstractButton.isEnabled() && abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n, n2, 14, 14);
            } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getFocusColors(), n, n2, 14, 14);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getColHeaderColors(), n, n2, 14, 14);
            }
            graphics2D.setClip(shape);
            Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!buttonModel.isRollover()) {
                object2 = graphics2D.getComposite();
                object = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite((Composite)object);
                graphics2D.setColor(Color.white);
                graphics2D.drawOval(n + 1, n2 + 1, 12, 12);
                graphics2D.setComposite((Composite)object2);
            }
            if (abstractButton.isEnabled()) {
                if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus()) {
                    object2 = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 30.0);
                    object = ColorHelper.darker(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 20.0);
                    graphics.setColor((Color)object2);
                    graphics.drawOval(n - 1, n2 - 1, 16, 16);
                    graphics.setColor((Color)object);
                    graphics2D.drawOval(n, n2, 14, 14);
                } else {
                    graphics.setColor(AbstractLookAndFeel.getFrameColor());
                    graphics2D.drawOval(n, n2, 14, 14);
                }
            } else {
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                graphics2D.drawOval(n, n2, 14, 14);
            }
            if (buttonModel.isSelected()) {
                if (abstractButton.isEnabled()) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                }
                graphics2D.fillOval(n + 4, n2 + 4, 7, 7);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private static final Color MENU_ITEM_BACKGROUND = new Color(248, 248, 248);
        private static Icon checkIcon = new LazyImageIcon("icons/CheckSymbol.gif");
        private static Icon checkIconDisabled = new LazyImageIcon("icons/CheckSymbolDisabled.gif");
        private static Icon checkPressedIcon = new LazyImageIcon("icons/CheckPressedSymbol.gif");
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (component instanceof JCheckBoxMenuItem) {
                graphics.setColor(MENU_ITEM_BACKGROUND);
                graphics.fillRect(n, n2, 15, 15);
                if (abstractButton.isEnabled()) {
                    graphics.setColor(AbstractLookAndFeel.getFrameColor());
                } else {
                    graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                }
                graphics.drawRect(n, n2, 15, 15);
            } else if (abstractButton.isEnabled()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n, n2, 15, 15);
                } else {
                    if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus()) {
                        JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getFocusColors(), n, n2, 15, 15);
                    } else {
                        JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getColHeaderColors(), n, n2, 15, 15);
                    }
                    if (!buttonModel.isPressed()) {
                        graphics.setColor(Color.white);
                        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 15 - 2);
                        graphics.drawLine(n + 15 - 1, n2 + 1, n + 15 - 1, n2 + 15 - 2);
                    }
                }
                if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && abstractButton.hasFocus()) {
                    Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 30.0);
                    Color color2 = ColorHelper.darker(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 20.0);
                    graphics.setColor(color);
                    graphics.drawRect(n - 1, n2 - 1, 17, 17);
                    graphics.setColor(color2);
                    graphics.drawRect(n, n2, 15, 15);
                } else {
                    graphics.setColor(AbstractLookAndFeel.getFrameColor());
                    graphics.drawRect(n, n2, 15, 15);
                }
            } else {
                graphics.setColor(AbstractLookAndFeel.getDisabledBackgroundColor());
                graphics.fillRect(n, n2, 15, 15);
                graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                graphics.drawRect(n, n2, 15, 15);
            }
            int n3 = n + (15 - checkIcon.getIconWidth()) / 2 + 1;
            int n4 = n2 + (15 - checkIcon.getIconHeight()) / 2 + 1;
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                checkPressedIcon.paintIcon(component, graphics, n3, n4);
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isEnabled()) {
                    checkIcon.paintIcon(component, graphics, n3, n4);
                } else {
                    checkIconDisabled.paintIcon(component, graphics, n3, n4);
                }
            }
        }

        public int getIconWidth() {
            return 19;
        }

        public int getIconHeight() {
            return 15;
        }
    }
}

