/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class BaseRootPaneUI
extends BasicRootPaneUI {
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int MAXIMIZED_BOTH = 6;
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final Dimension MINIMUM_SIZE = new Dimension(120, 80);
    private static final Dimension MAXIMUM_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private BaseTitlePane titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor savedCursor = null;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseRootPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        if (DecorationHelper.getWindowDecorationStyle(this.root) != 0) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    public void installBorder(JRootPane jRootPane) {
        int n = DecorationHelper.getWindowDecorationStyle(jRootPane);
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, borderKeys[n]);
        }
    }

    public void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    public void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
            if (JTattooUtilities.getJavaVersion() >= 1.5 && JTattooUtilities.getJavaVersion() <= 1.6) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (BaseRootPaneUI.this.window != null && BaseRootPaneUI.this.window instanceof JFrame) {
                            JFrame jFrame = (JFrame)BaseRootPaneUI.this.window;
                            jFrame.update(jFrame.getGraphics());
                        }
                    }
                });
            }
        }
    }

    public void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    public void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    public void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    public void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        this.setTitlePane(jRootPane, this.createTitlePane(jRootPane));
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            this.savedCursor = this.window.getCursor();
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    public void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n = DecorationHelper.getWindowDecorationStyle(jRootPane);
        if (n == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(this.savedCursor);
        }
        this.window = null;
    }

    public BaseTitlePane createTitlePane(JRootPane jRootPane) {
        return new BaseTitlePane(jRootPane, this);
    }

    public MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler();
    }

    public LayoutManager createLayoutManager() {
        return new BaseRootLayout();
    }

    public void setTitlePane(JRootPane jRootPane, BaseTitlePane baseTitlePane) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        BaseTitlePane baseTitlePane2 = this.getTitlePane();
        if (baseTitlePane2 != null) {
            baseTitlePane2.setVisible(false);
            jLayeredPane.remove(baseTitlePane2);
        }
        if (baseTitlePane != null) {
            jLayeredPane.add((Component)baseTitlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            baseTitlePane.setVisible(true);
        }
        this.titlePane = baseTitlePane;
    }

    public BaseTitlePane getTitlePane() {
        return this.titlePane;
    }

    public JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
        if (string.equals("windowDecorationStyle")) {
            int n = DecorationHelper.getWindowDecorationStyle(jRootPane);
            this.uninstallClientDecorations(jRootPane);
            if (n != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(jRootPane);
            if (DecorationHelper.getWindowDecorationStyle(jRootPane) != 0) {
                this.installWindowListeners(jRootPane, jRootPane.getParent());
            }
        }
    }

    private boolean isDynamicLayout() {
        return AbstractLookAndFeel.getTheme().isDynamicLayout();
    }

    private static class ResizingPanel
    extends JPanel {
        private BufferedImage bi = null;

        public ResizingPanel(BufferedImage bufferedImage) {
            this.bi = bufferedImage;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.drawImage(this.bi, 0, 0, null);
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private boolean isResizingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private Container savedContentPane = null;
        private ResizingPanel resizingPanel = null;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block15: {
                int n;
                Dialog dialog;
                Frame frame;
                Window window;
                Point point;
                block16: {
                    int n2;
                    PropertyChangeListener[] propertyChangeListenerArray;
                    Window window2;
                    if (!(mouseEvent.getSource() instanceof Window)) break block15;
                    JRootPane jRootPane = BaseRootPaneUI.this.getRootPane();
                    if (DecorationHelper.getWindowDecorationStyle(jRootPane) == 0) {
                        return;
                    }
                    point = mouseEvent.getPoint();
                    window = (Window)mouseEvent.getSource();
                    if (window != null) {
                        window.toFront();
                    }
                    Point point2 = SwingUtilities.convertPoint(window, point, BaseRootPaneUI.this.getTitlePane());
                    frame = null;
                    dialog = null;
                    if (window instanceof Frame) {
                        frame = (Frame)window;
                    } else if (window instanceof Dialog) {
                        dialog = (Dialog)window;
                    }
                    int n3 = n = frame != null ? DecorationHelper.getExtendedState(frame) : 0;
                    if (BaseRootPaneUI.this.getTitlePane() == null || !BaseRootPaneUI.this.getTitlePane().contains(point2)) break block16;
                    if ((frame == null || (n & 6) != 0) && dialog == null || point.y < 5 || point.x < 5 || point.x >= window.getWidth() - 5) break block15;
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        window2 = (JFrame)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = window2.getPropertyChangeListeners();
                        for (n2 = 0; n2 < propertyChangeListenerArray.length; ++n2) {
                            propertyChangeListenerArray[n2].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoving", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (BaseRootPaneUI.this.window instanceof JDialog) {
                        window2 = (JDialog)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = window2.getPropertyChangeListeners();
                        for (n2 = 0; n2 < propertyChangeListenerArray.length; ++n2) {
                            propertyChangeListenerArray[n2].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoving", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    break block15;
                }
                if (frame != null && frame.isResizable() && (n & 6) == 0 || dialog != null && dialog.isResizable()) {
                    int n4;
                    PropertyChangeListener[] propertyChangeListenerArray;
                    Object object;
                    this.isResizingWindow = true;
                    if (!BaseRootPaneUI.this.isDynamicLayout()) {
                        this.savedContentPane = BaseRootPaneUI.this.getRootPane().getContentPane();
                        object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                        propertyChangeListenerArray = ((GraphicsConfiguration)object).createCompatibleImage(this.savedContentPane.getWidth(), this.savedContentPane.getHeight());
                        this.savedContentPane.paint(propertyChangeListenerArray.getGraphics());
                        this.resizingPanel = new ResizingPanel((BufferedImage)propertyChangeListenerArray);
                        BaseRootPaneUI.this.getRootPane().setContentPane(this.resizingPanel);
                    }
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                    this.dragWidth = window.getWidth();
                    this.dragHeight = window.getHeight();
                    this.dragCursor = this.getCursor(this.calculateCorner(window, point.x, point.y));
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        object = (JFrame)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = ((Component)object).getPropertyChangeListeners();
                        for (n4 = 0; n4 < propertyChangeListenerArray.length; ++n4) {
                            propertyChangeListenerArray[n4].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResizing", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (BaseRootPaneUI.this.window instanceof JDialog) {
                        object = (JDialog)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = ((Component)object).getPropertyChangeListeners();
                        for (n4 = 0; n4 < propertyChangeListenerArray.length; ++n4) {
                            propertyChangeListenerArray[n4].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResizing", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Window) {
                Window window = (Window)mouseEvent.getSource();
                if (window != null) {
                    int n;
                    PropertyChangeListener[] propertyChangeListenerArray;
                    Window window2;
                    if (!BaseRootPaneUI.this.isDynamicLayout() && this.isResizingWindow) {
                        BaseRootPaneUI.this.getRootPane().setContentPane(this.savedContentPane);
                        BaseRootPaneUI.this.getRootPane().updateUI();
                        this.resizingPanel = null;
                    } else if (this.dragCursor != 0 && !BaseRootPaneUI.this.window.isValid()) {
                        window.validate();
                        BaseRootPaneUI.this.getRootPane().repaint();
                    }
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        window2 = (JFrame)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = window2.getPropertyChangeListeners();
                        for (n = 0; n < propertyChangeListenerArray.length; ++n) {
                            if (this.isMovingWindow) {
                                propertyChangeListenerArray[n].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoved", Boolean.FALSE, Boolean.FALSE));
                                continue;
                            }
                            propertyChangeListenerArray[n].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResized", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (BaseRootPaneUI.this.window instanceof JDialog) {
                        window2 = (JDialog)BaseRootPaneUI.this.window;
                        propertyChangeListenerArray = window2.getPropertyChangeListeners();
                        for (n = 0; n < propertyChangeListenerArray.length; ++n) {
                            if (this.isMovingWindow) {
                                propertyChangeListenerArray[n].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoved", Boolean.FALSE, Boolean.FALSE));
                                continue;
                            }
                            propertyChangeListenerArray[n].propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResized", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                }
                this.isMovingWindow = false;
                this.isResizingWindow = false;
                this.dragCursor = 0;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Window) {
                JRootPane jRootPane = BaseRootPaneUI.this.getRootPane();
                if (DecorationHelper.getWindowDecorationStyle(jRootPane) == 0) {
                    return;
                }
                Window window = (Window)mouseEvent.getSource();
                Frame frame = null;
                Dialog dialog = null;
                if (window instanceof Frame) {
                    frame = (Frame)window;
                } else if (window instanceof Dialog) {
                    dialog = (Dialog)window;
                }
                int n = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
                if (n != 0 && (frame != null && frame.isResizable() && (DecorationHelper.getExtendedState(frame) & 6) == 0 || dialog != null && dialog.isResizable())) {
                    window.setCursor(Cursor.getPredefinedCursor(n));
                } else {
                    window.setCursor(BaseRootPaneUI.this.savedCursor);
                }
            }
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width += n3;
            rectangle.height += n4;
            if (dimension != null) {
                int n5;
                if (rectangle.width < dimension.width) {
                    n5 = dimension.width - rectangle.width;
                    if (n != 0) {
                        rectangle.x -= n5;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n5 = dimension.height - rectangle.height;
                    if (n2 != 0) {
                        rectangle.y -= n5;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Window) {
                Window window = (Window)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                if (this.isMovingWindow) {
                    Point point2 = window.getLocationOnScreen();
                    point2.x += point.x - this.dragOffsetX;
                    point2.y += point.y - this.dragOffsetY;
                    window.setLocation(point2);
                } else if (this.dragCursor != 0) {
                    Rectangle rectangle = window.getBounds();
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    Dimension dimension = MINIMUM_SIZE;
                    switch (this.dragCursor) {
                        case 11: {
                            this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                            break;
                        }
                        case 9: {
                            this.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                            break;
                        }
                        case 8: {
                            this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                            break;
                        }
                        case 10: {
                            this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                            break;
                        }
                        case 7: {
                            this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                            break;
                        }
                        case 5: {
                            this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                            break;
                        }
                        case 6: {
                            this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                            break;
                        }
                        case 4: {
                            this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                            break;
                        }
                    }
                    if (!rectangle.equals(rectangle2)) {
                        window.setLocation(rectangle.x, rectangle.y);
                        window.setSize(rectangle.width, rectangle.height);
                        window.validate();
                        BaseRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Window) {
                Window window = (Window)mouseEvent.getSource();
                window.setCursor(BaseRootPaneUI.this.savedCursor);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof Window) {
                Window window = (Window)mouseEvent.getSource();
                if (!(window instanceof Frame)) {
                    return;
                }
                Frame frame = (Frame)window;
                Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), BaseRootPaneUI.this.getTitlePane());
                int n = DecorationHelper.getExtendedState(frame);
                if (BaseRootPaneUI.this.getTitlePane() != null && BaseRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                    if ((n & 6) != 0) {
                        DecorationHelper.setExtendedState(frame, n & 0xFFFFFFF9);
                    } else {
                        DecorationHelper.setExtendedState(frame, n | 6);
                    }
                    return;
                }
            }
        }

        private int calculateCorner(Component component, int n, int n2) {
            int n3 = this.calculatePosition(n, component.getWidth());
            int n4 = this.calculatePosition(n2, component.getHeight());
            if (n3 == -1 || n4 == -1) {
                return -1;
            }
            return n4 * 5 + n3;
        }

        private int getCursor(int n) {
            if (n == -1) {
                return 0;
            }
            return cursorMapping[n];
        }

        private int calculatePosition(int n, int n2) {
            if (n < 5) {
                return 0;
            }
            if (n < 16) {
                return 1;
            }
            if (n >= n2 - 5) {
                return 4;
            }
            if (n >= n2 - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class BaseRootLayout
    implements LayoutManager2 {
        private BaseRootLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            BaseTitlePane baseTitlePane;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (DecorationHelper.getWindowDecorationStyle(jRootPane) != 0 && jRootPane.getUI() instanceof BaseRootPaneUI && (baseTitlePane = ((BaseRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = baseTitlePane.getPreferredSize()) != null) {
                n5 = dimension.width;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n5 + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            return MINIMUM_SIZE;
        }

        public Dimension maximumLayoutSize(Container container) {
            return MAXIMUM_SIZE;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                if (DecorationHelper.getWindowDecorationStyle(jRootPane) != 0 && jRootPane.getUI() instanceof BaseRootPaneUI) {
                    serializable = ((BaseRootPaneUI)jRootPane.getUI()).getTitlePane();
                    int n4 = 0;
                    if (serializable != null) {
                        n4 = ((Component)serializable).getSize().height;
                    }
                    jRootPane.getGlassPane().setBounds(insets.left, insets.top + n4, n2, n3 - n4);
                } else {
                    jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
                }
            }
            if (DecorationHelper.getWindowDecorationStyle(jRootPane) != 0 && jRootPane.getUI() instanceof BaseRootPaneUI && (serializable = ((BaseRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n5 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n5);
                n += n5;
            }
            if (jRootPane.getJMenuBar() != null) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

