/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMaps {
    private static Document actionMapsDoc;

    public static void exportActionMaps(File exportMapsFile) {
        if (actionMapsDoc == null) {
            return;
        }
        try {
            DOMSource source = new DOMSource(actionMapsDoc);
            StreamResult result = new StreamResult(exportMapsFile);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importActionMapsFromStream(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            actionMapsDoc = docBuilder.parse(is);
            actionMapsDoc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importActionMaps(File actionMapsFile) {
        if (actionMapsFile == null) {
            return;
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            actionMapsDoc = docBuilder.parse(actionMapsFile);
            actionMapsDoc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setActionKeys(String actionMap, String action, List<String> inputKeys) {
        if (actionMap == null || action == null || actionMapsDoc == null) {
            return;
        }
        if (inputKeys == null) {
            inputKeys = new ArrayList<String>();
        }
        if (inputKeys.size() < 1) {
            inputKeys.add("null");
        }
        for (int i = 0; i < inputKeys.size(); ++i) {
            if (inputKeys.get(i) != null && inputKeys.get(i).length() != 0) continue;
            inputKeys.set(i, "null");
        }
        int numInputKeys = inputKeys.size();
        NodeList actionMapsList = actionMapsDoc.getElementsByTagName("actionmap");
        for (int i = 0; i < actionMapsList.getLength(); ++i) {
            Element actionMapElement;
            Node actionMapNode = actionMapsList.item(i);
            if (actionMapNode.getNodeType() != 1 || !(actionMapElement = (Element)actionMapNode).getAttribute("name").equals(actionMap)) continue;
            NodeList actionList = actionMapElement.getElementsByTagName("action");
            for (int j = 0; j < actionList.getLength(); ++j) {
                Element actionElement = (Element)actionList.item(j);
                if (!actionElement.getAttribute("name").equals(action)) continue;
                NodeList keyList = actionElement.getElementsByTagName("key");
                int numKeys = keyList.getLength();
                for (int k = 0; k < numKeys; ++k) {
                    Element keyElement = (Element)keyList.item(k);
                    if (k >= numInputKeys) continue;
                    keyElement.setAttribute("name", inputKeys.get(k));
                }
                if (numKeys < numInputKeys) {
                    while (numKeys < numInputKeys) {
                        Element firstElement = (Element)keyList.item(0);
                        Element newElement = (Element)firstElement.cloneNode(false);
                        newElement.setAttribute("name", inputKeys.get(++numKeys - 1));
                        actionElement.appendChild(newElement);
                    }
                } else if (numKeys > numInputKeys) {
                    while (numKeys > numInputKeys) {
                        actionElement.removeChild(keyList.item(--numKeys - 1));
                    }
                }
                return;
            }
        }
    }

    public static List<String> getActionKeys(String actionMap, String action) {
        if (actionMap == null || action == null || actionMapsDoc == null) {
            return null;
        }
        boolean actionFound = false;
        ArrayList<String> keys = new ArrayList<String>(2);
        NodeList actionMapsList = actionMapsDoc.getElementsByTagName("actionmap");
        int numActionMaps = actionMapsList.getLength();
        block0: for (int i = 0; i < numActionMaps; ++i) {
            Element actionMapElement;
            Node actionMapNode = actionMapsList.item(i);
            if (actionMapNode.getNodeType() != 1 || !(actionMapElement = (Element)actionMapNode).getAttribute("name").equals(actionMap)) continue;
            NodeList actionList = actionMapElement.getElementsByTagName("action");
            int numActions = actionList.getLength();
            for (int j = 0; j < numActions; ++j) {
                Element actionElement = (Element)actionList.item(j);
                if (!actionElement.getAttribute("name").equals(action)) continue;
                actionFound = true;
                NodeList keyList = actionElement.getElementsByTagName("key");
                int numKeys = keyList.getLength();
                for (int k = 0; k < numKeys; ++k) {
                    Element keyElement = (Element)keyList.item(k);
                    keys.add(keyElement.getAttribute("name"));
                }
                continue block0;
            }
        }
        if (!actionFound) {
            return null;
        }
        return keys;
    }
}

