/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.ActionTableCellRenderer;
import mwllactionmapper.ActionTableModel;
import mwllactionmapper.KeyPanel;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.MappingPanel;
import mwllactionmapper.model.ActionModel;
import mwllactionmapper.model.KeyModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionPanel
extends JPanel
implements MouseListener {
    private MappingPanel.PanelType panelType;
    private KeyPanel keyPanel_1;
    private KeyPanel keyPanel_2;
    private JLabel imageLabel;
    private JTextArea infoTextArea;
    private JTable actionTable;
    private ButtonGroup autoexecButtonGroup;
    private JPopupMenu autoexecPopupMenu;
    private JMenuItem autoexecTitleItem;
    private JScrollPane jScrollPane1;
    private JRadioButtonMenuItem noRadioButton;
    private JRadioButtonMenuItem yesRadioButton;

    public ActionPanel(MappingPanel.PanelType panelType) {
        this.initComponents();
        this.panelType = panelType;
        this.initSelections();
        ActionModel.loadProperties();
        this.actionTable.setDefaultRenderer(ActionSelection.class, new ActionTableCellRenderer());
        this.actionTable.setDefaultRenderer(KeyBindCellData.class, new ActionTableCellRenderer());
        this.actionTable.addMouseListener(this);
    }

    private void initSelections() {
        if (MappingPanel.PanelType.PLAYER == this.panelType) {
            this.populatePlayerActions();
        } else if (MappingPanel.PanelType.VEHICLE == this.panelType) {
            this.populateVehicleActions();
        } else if (MappingPanel.PanelType.MECH == this.panelType) {
            this.populateMechActions();
        } else if (MappingPanel.PanelType.TANK == this.panelType) {
            this.populateTankActions();
        } else if (MappingPanel.PanelType.VTOL == this.panelType) {
            this.populateVtolActions();
        } else if (MappingPanel.PanelType.AEROSPACE == this.panelType) {
            this.populateAerospaceActions();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.actionTable == e.getSource() && SwingUtilities.isLeftMouseButton(e)) {
            ActionSelection actionObj = this.getActionAtRow(this.actionTable.rowAtPoint(e.getPoint()));
            this.updateSelection(actionObj);
            if (actionObj != null && actionObj.isAutoexecCvar()) {
                String actionSelection = MWLLActionmapperView.reference.autoexecModel.getPropertyValue(actionObj.getActionName());
                this.autoexecTitleItem.setText(actionObj.getDisplayName());
                this.autoexecTitleItem.setToolTipText(actionObj.getActionName());
                if ("1".equals(actionSelection)) {
                    this.autoexecButtonGroup.setSelected(this.yesRadioButton.getModel(), true);
                } else {
                    this.autoexecButtonGroup.setSelected(this.noRadioButton.getModel(), true);
                }
                this.autoexecPopupMenu.show(this.actionTable, e.getX() + 5, e.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ActionSelection actionObj = this.getActionAtRow(this.actionTable.rowAtPoint(e.getPoint()));
        this.updateSelection(actionObj);
    }

    private void initComponents() {
        this.autoexecPopupMenu = new JPopupMenu();
        this.autoexecTitleItem = new JMenuItem();
        this.yesRadioButton = new JRadioButtonMenuItem();
        this.noRadioButton = new JRadioButtonMenuItem();
        this.autoexecButtonGroup = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.actionTable = new JTable();
        this.autoexecPopupMenu.setName("autoexecPopupMenu");
        ResourceMap resourceMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getResourceMap(ActionPanel.class);
        this.autoexecTitleItem.setBackground(resourceMap.getColor("autoexecTitleItem.background"));
        this.autoexecTitleItem.setForeground(resourceMap.getColor("autoexecTitleItem.foreground"));
        this.autoexecTitleItem.setName("autoexecTitleItem");
        this.autoexecTitleItem.setOpaque(true);
        this.autoexecPopupMenu.add(this.autoexecTitleItem);
        ApplicationActionMap actionMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getActionMap(ActionPanel.class, (Object)this);
        this.yesRadioButton.setAction(actionMap.get("updateAutoexecValue"));
        this.autoexecButtonGroup.add(this.yesRadioButton);
        this.yesRadioButton.setText(resourceMap.getString("yesRadioButton.text", new Object[0]));
        this.yesRadioButton.setName("yesRadioButton");
        this.autoexecPopupMenu.add(this.yesRadioButton);
        this.noRadioButton.setAction(actionMap.get("updateAutoexecValue"));
        this.autoexecButtonGroup.add(this.noRadioButton);
        this.noRadioButton.setText(resourceMap.getString("noRadioButton.text", new Object[0]));
        this.noRadioButton.setName("noRadioButton");
        this.autoexecPopupMenu.add(this.noRadioButton);
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setName("Form");
        this.jScrollPane1.setBackground(resourceMap.getColor("jScrollPane1.background"));
        this.jScrollPane1.setName("jScrollPane1");
        this.actionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"Action", "Binding #1", "Binding #2"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.actionTable.setCursor(new Cursor(0));
        this.actionTable.setName("actionTable");
        this.actionTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.actionTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 341, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 573, Short.MAX_VALUE));
    }

    private void populatePlayerActions() {
        ActionTableModel model = ActionModel.populatePlayerActions();
        this.actionTable.setModel(model);
    }

    private void populateVehicleActions() {
        ActionTableModel model = ActionModel.populateVehicleActions();
        this.actionTable.setModel(model);
    }

    private void populateVtolActions() {
        ActionTableModel model = ActionModel.populateVtolActions();
        this.actionTable.setModel(model);
    }

    private void populateMechActions() {
        ActionTableModel model = ActionModel.populateMechActions();
        this.actionTable.setModel(model);
    }

    private void populateTankActions() {
        ActionTableModel model = ActionModel.populateTankActions();
        this.actionTable.setModel(model);
    }

    private void populateAerospaceActions() {
        ActionTableModel model = ActionModel.populateAerospaceActions();
        this.actionTable.setModel(model);
    }

    public void clearSelection() {
        DefaultListSelectionModel selModel = new DefaultListSelectionModel();
        selModel.setSelectionMode(0);
        this.actionTable.setSelectionModel(selModel);
        this.updateSelection();
    }

    @Action
    public void updateAutoexecValue() {
        String autoexecKey = this.autoexecTitleItem.getToolTipText();
        String autoexecValue = this.autoexecButtonGroup.isSelected(this.yesRadioButton.getModel()) ? "1" : "0";
        MWLLActionmapperView.reference.autoexecModel.setPropertyValue(autoexecKey, autoexecValue);
        this.updateXML();
        String label = "Set '" + autoexecValue + "' for CVAR '" + autoexecKey + "'";
        MWLLActionmapperView.setStatusLabel(label);
    }

    public void updateSelection() {
        this.updateSelection(ActionSelection.NULL_SELECTION);
    }

    private void updateSelection(ActionSelection actionObj) {
        if (actionObj == ActionSelection.NULL_SELECTION) {
            actionObj = this.getSelectedAction();
        }
        if (actionObj == null || actionObj.isCategoryHeader() || actionObj.isMissing() || actionObj.isAutoexecCvar()) {
            this.keyPanel_1.setSelectedKey(null);
            this.keyPanel_2.setSelectedKey(null);
            this.keyPanel_1.setEnabled(false);
            this.keyPanel_2.setEnabled(false);
            this.imageLabel.setIcon(null);
            this.infoTextArea.setText("Select an action from the table to the left");
            if (actionObj != null && actionObj.isMissing() && !actionObj.isOptional()) {
                String missingLabelText = "Action missing, please create a new actionmaps";
                URL imgURL = this.getClass().getResource("resources/question.png");
                ImageIcon icon = new ImageIcon(imgURL);
                this.keyPanel_1.setConflictLabelText(missingLabelText);
                this.keyPanel_1.setConflictLabelIcon(icon);
                this.keyPanel_2.setConflictLabelText(missingLabelText);
                this.keyPanel_2.setConflictLabelIcon(icon);
            } else {
                this.keyPanel_1.setConflictLabelText(null);
                this.keyPanel_1.setConflictLabelIcon(null);
                this.keyPanel_2.setConflictLabelText(null);
                this.keyPanel_2.setConflictLabelIcon(null);
            }
            return;
        }
        List<String> keys = ActionModel.getActionKeys(actionObj, this.panelType);
        String key1value = null;
        String key2value = null;
        if (keys != null) {
            if (keys.size() >= 1) {
                key1value = keys.get(0);
            }
            if (keys.size() >= 2) {
                key2value = keys.get(1);
            }
        }
        this.keyPanel_1.setEnabled(true);
        this.keyPanel_2.setEnabled(true);
        this.keyPanel_1.setAnalogOnly(actionObj.isAnalogOnly());
        this.keyPanel_2.setAnalogOnly(actionObj.isAnalogOnly());
        this.keyPanel_1.setSelectedKey(key1value);
        this.keyPanel_2.setSelectedKey(key2value);
        this.infoTextArea.setText(actionObj.getInfoText(this.panelType));
        this.imageLabel.setIcon(actionObj.getIcon(this.panelType));
        this.updateKeyConflictLabels();
        this.updateTableBindingColumnData();
    }

    public void setKeyPanel1(KeyPanel keyPanel_1) {
        this.keyPanel_1 = keyPanel_1;
        this.keyPanel_1.setActionPanel(this);
        this.keyPanel_1.setEnabled(false);
    }

    public void setKeyPanel2(KeyPanel keyPanel_2) {
        this.keyPanel_2 = keyPanel_2;
        this.keyPanel_2.setActionPanel(this);
        this.keyPanel_2.setEnabled(false);
    }

    public void updateXML() {
        if (this.actionTable.getSelectionModel().isSelectionEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(this.keyPanel_1.getSelectedKey());
        keys.add(this.keyPanel_2.getSelectedKey());
        ActionSelection actionObj = this.getSelectedAction();
        String actionName = actionObj.getActionName();
        String actionMapName = ActionModel.getActionMapName(actionName, this.panelType);
        ActionMaps.setActionKeys(actionMapName, actionName, keys);
        List<String> mirrorActionNames = ActionModel.getMirroredActionNames(actionName);
        for (String mirrorAction : mirrorActionNames) {
            ActionMaps.setActionKeys(actionMapName, mirrorAction, keys);
        }
        actionObj.setIsModified(true);
        MWLLActionmapperView.reference.setWorkingFileModified(true);
        this.performConflictCheck();
        this.updateKeyConflictLabels();
        this.updateTableBindingColumnData();
        this.actionTable.updateUI();
    }

    public boolean performConflictCheck() {
        return ActionModel.performConflictCheck(this.actionTable, this.panelType);
    }

    public void updateTableBindingColumnData() {
        ActionTableModel model = (ActionTableModel)this.actionTable.getModel();
        if (model == null) {
            return;
        }
        int numRows = model.getRowCount();
        if (model.getColumnCount() == 0 || numRows == 0) {
            return;
        }
        for (int i = 0; i < numRows; ++i) {
            ActionSelection actionObj = (ActionSelection)model.getValueAt(i, 0);
            if (actionObj.isCategoryHeader() && actionObj.getDisplayName() != null) {
                ActionSelection categoryRow = new ActionSelection("");
                model.setValueAt(categoryRow, i, 1);
                model.setValueAt(categoryRow, i, 2);
                continue;
            }
            if (actionObj.isAutoexecCvar()) {
                KeyBindCellData keyData;
                String value = MWLLActionmapperView.reference.autoexecModel.getPropertyValue(actionObj.getActionName());
                if ("1".equals(value)) {
                    keyData = new KeyBindCellData("Yes");
                    keyData.setTooltip("1");
                    keyData.setHasActionConflict(actionObj.hasConflict());
                    keyData.setModified(actionObj.isModified());
                    model.setValueAt(keyData, i, 1);
                } else {
                    keyData = new KeyBindCellData("No");
                    keyData.setTooltip("0");
                    keyData.setHasActionConflict(actionObj.hasConflict());
                    keyData.setModified(actionObj.isModified());
                    model.setValueAt(keyData, i, 1);
                }
                model.setValueAt(new KeyBindCellData(null), i, 2);
                continue;
            }
            List<String> keys = ActionModel.getActionKeys(actionObj, this.panelType);
            if (keys != null && !keys.isEmpty()) {
                KeyBindCellData keyData;
                String keyName;
                int numKeys = keys.size();
                if (numKeys >= 1) {
                    keyName = keys.get(0);
                    keyData = new KeyBindCellData(keyName);
                    keyData.setTooltip(KeyModel.getKeyDisplayName(keyName, true));
                    keyData.setHasActionConflict(actionObj.hasConflict());
                    keyData.setModified(actionObj.isModified());
                    if (actionObj.getConflictMessage() != null && keyName.equals(actionObj.getConflictMessage().substring(0, actionObj.getConflictMessage().indexOf(";")))) {
                        keyData.setKeyConflict(true);
                    }
                    model.setValueAt(keyData, i, 1);
                }
                if (numKeys >= 2) {
                    keyName = keys.get(1);
                    keyData = new KeyBindCellData(keyName);
                    keyData.setTooltip(KeyModel.getKeyDisplayName(keyName, true));
                    keyData.setHasActionConflict(actionObj.hasConflict());
                    keyData.setModified(actionObj.isModified());
                    if (actionObj.getConflictMessage() != null && keyName.equals(actionObj.getConflictMessage().substring(0, actionObj.getConflictMessage().indexOf(";")))) {
                        keyData.setKeyConflict(true);
                    }
                    model.setValueAt(keyData, i, 2);
                    continue;
                }
                model.setValueAt(new KeyBindCellData(null), i, 2);
                continue;
            }
            model.setValueAt(new KeyBindCellData(null), i, 1);
            model.setValueAt(new KeyBindCellData(null), i, 2);
        }
    }

    private void updateKeyConflictLabels() {
        ActionSelection actionObj = this.getSelectedAction();
        this.keyPanel_1.setConflictLabelText(null);
        this.keyPanel_1.setConflictLabelIcon(null);
        this.keyPanel_2.setConflictLabelText(null);
        this.keyPanel_2.setConflictLabelIcon(null);
        if (actionObj != null && actionObj.getConflictMessage() != null) {
            String key1value = this.keyPanel_1.getSelectedKey();
            String key2value = this.keyPanel_2.getSelectedKey();
            StringTokenizer tk = new StringTokenizer(actionObj.getConflictMessage(), ";");
            String conflictKey = tk.nextToken();
            String conflictText = tk.nextToken();
            URL imgURL = this.getClass().getResource("resources/conflict.png");
            ImageIcon icon = new ImageIcon(imgURL);
            if (key1value != null && conflictKey.equals(key1value.replaceFirst("inv", "").replaceFirst("raw", ""))) {
                this.keyPanel_1.setConflictLabelText(conflictText);
                this.keyPanel_1.setConflictLabelIcon(icon);
            } else if (key2value != null && conflictKey.equals(key2value.replaceFirst("inv", "").replaceFirst("raw", ""))) {
                this.keyPanel_2.setConflictLabelText(conflictText);
                this.keyPanel_2.setConflictLabelIcon(icon);
            }
        }
    }

    public void setAllActionSelectionsNotModified() {
        for (ActionSelection action : this.getAllActionSelections()) {
            action.setIsModified(false);
        }
        this.updateUI();
    }

    private List<ActionSelection> getAllActionSelections() {
        ArrayList<ActionSelection> actions = new ArrayList<ActionSelection>();
        if (this.actionTable.getModel() != null) {
            DefaultTableModel listModel = (DefaultTableModel)this.actionTable.getModel();
            for (int i = 0; i < listModel.getRowCount(); ++i) {
                actions.add((ActionSelection)listModel.getValueAt(i, 0));
            }
        }
        return actions;
    }

    public ActionSelection getSelectedAction() {
        int selRow = this.actionTable.getSelectedRow();
        return this.getActionAtRow(selRow);
    }

    public ActionSelection getActionAtRow(int row) {
        if (row < 0) {
            return null;
        }
        return (ActionSelection)this.actionTable.getModel().getValueAt(row, 0);
    }

    public void setInfoTextArea(JTextArea infoTextArea) {
        this.infoTextArea = infoTextArea;
    }

    public void setImageLabel(JLabel imageLabel) {
        this.imageLabel = imageLabel;
    }

    public static class KeyBindCellData {
        private String keybind;
        private String tooltip;
        private boolean actionHasConflict = false;
        private boolean isModified = false;
        private boolean keyConflict = false;

        public KeyBindCellData(String keybind) {
            this.keybind = keybind;
        }

        public void setModified(boolean modified) {
            this.isModified = modified;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public boolean hasKeyConflict() {
            return this.keyConflict;
        }

        public void setKeyConflict(boolean keyConflict) {
            this.keyConflict = keyConflict;
        }

        public void setHasActionConflict(boolean hasConflict) {
            this.actionHasConflict = hasConflict;
        }

        public boolean hasActionConflict() {
            return this.actionHasConflict;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        public String toString() {
            if (this.keybind == null || this.keybind.equals("null")) {
                return "";
            }
            return this.keybind;
        }
    }

    public static class ActionSelection {
        public static final ActionSelection NULL_SELECTION = new ActionSelection("NULL");
        private String displayName;
        private String actionName;
        private boolean isAnalogOnly;
        private boolean isOptional;
        private boolean isAutoexecCvar;
        private boolean isModified = false;
        private boolean hasConflict = false;
        private String conflictMessage = null;
        private boolean isCategoryHeader = false;
        private boolean isMissing = false;

        public ActionSelection(String categoryHeaderName) {
            this.isCategoryHeader = true;
            this.displayName = categoryHeaderName;
        }

        public ActionSelection(String displayName, String actionName) {
            this(displayName, actionName, false, false);
        }

        public ActionSelection(String displayName, String actionName, boolean isAnalogOnly) {
            this(displayName, actionName, isAnalogOnly, false);
        }

        public ActionSelection(String displayName, String actionName, boolean isAnalogOnly, boolean isOptional) {
            this.displayName = displayName;
            this.actionName = actionName;
            this.isAnalogOnly = isAnalogOnly;
            this.isOptional = isOptional;
        }

        public static ActionSelection createAutoexecCvarAction(String displayName, String actionName) {
            ActionSelection actSel = new ActionSelection(displayName, actionName);
            actSel.setIsAutoexecCvar(true);
            return actSel;
        }

        public boolean isAutoexecCvar() {
            return this.isAutoexecCvar;
        }

        public void setIsAutoexecCvar(boolean isAutoexecCvar) {
            this.isAutoexecCvar = isAutoexecCvar;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean isCategoryHeader() {
            return this.isCategoryHeader;
        }

        public boolean isMissing() {
            return this.isMissing;
        }

        public void setIsMissing(boolean isMissing) {
            this.isMissing = isMissing;
        }

        public String getActionName() {
            return this.actionName;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean hasConflict() {
            return this.hasConflict;
        }

        public void setHasConflict(boolean hasConflict) {
            this.hasConflict = hasConflict;
        }

        public void setConflictMessage(String conflictMessage) {
            this.conflictMessage = conflictMessage;
        }

        public String getConflictMessage() {
            return this.conflictMessage;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public void setIsModified(boolean isModified) {
            this.isModified = isModified;
        }

        public boolean isAnalogOnly() {
            return this.isAnalogOnly;
        }

        public String toString() {
            return this.getDisplayName();
        }

        private Icon getIcon(MappingPanel.PanelType panelType) {
            return null;
        }

        private String getInfoText(MappingPanel.PanelType panelType) {
            String str = this.getDisplayName();
            if (panelType == null) {
                return str;
            }
            String infoText = ActionModel.getProperty(panelType.name().toLowerCase() + "." + this.getActionName());
            if (infoText != null && infoText.length() > 0) {
                str = infoText;
            }
            return str;
        }
    }
}

