/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import mwllactionmapper.ActionPanel;

public class ActionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;

    public ActionTableCellRenderer() {
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean backgroundOverride = false;
        if (object instanceof ActionPanel.ActionSelection) {
            ActionPanel.ActionSelection newAction = (ActionPanel.ActionSelection)object;
            ImageIcon icon = null;
            this.setForeground(Color.BLACK);
            String spacer = " ";
            if (newAction.isMissing()) {
                if (newAction.isOptional()) {
                    return null;
                }
                this.setForeground(Color.LIGHT_GRAY);
                this.setBackground(new Color(255, 64, 64));
                backgroundOverride = true;
                URL imgURL = this.getClass().getResource("resources/question.png");
                icon = new ImageIcon(imgURL);
                this.setIcon(icon);
                spacer = "";
            } else if (newAction.isModified()) {
                this.setForeground(Color.BLUE);
                URL imgURL = this.getClass().getResource("resources/modified.png");
                icon = new ImageIcon(imgURL);
                this.setIcon(icon);
                spacer = "";
            } else if (newAction.isCategoryHeader() && newAction.getDisplayName() != null) {
                this.setForeground(Color.WHITE);
                this.setBackground(Color.GRAY);
                backgroundOverride = true;
                spacer = "";
            }
            if (newAction.hasConflict()) {
                this.setForeground(Color.RED);
            }
            this.setIcon(icon);
            if (newAction.getDisplayName() == null) {
                this.setText(null);
            } else {
                this.setText(spacer + newAction.getDisplayName());
            }
            this.setToolTipText(newAction.getActionName());
        } else if (object instanceof ActionPanel.KeyBindCellData) {
            ActionPanel.KeyBindCellData keybind = (ActionPanel.KeyBindCellData)object;
            ImageIcon icon = null;
            this.setForeground(Color.BLACK);
            String spacer = " ";
            if (keybind.hasKeyConflict()) {
                URL imgURL = this.getClass().getResource("resources/conflict.png");
                icon = new ImageIcon(imgURL);
                this.setIcon(icon);
                spacer = "";
            }
            if (keybind.hasActionConflict()) {
                this.setForeground(Color.RED);
            } else if (keybind.isModified()) {
                this.setForeground(Color.BLUE);
            }
            this.setIcon(icon);
            if (keybind.toString() == null) {
                this.setText(null);
            } else {
                this.setText(spacer + keybind.toString());
            }
            this.setToolTipText(keybind.getTooltip());
        }
        if (isSelected) {
            if (!backgroundOverride) {
                this.setBackground(new Color(200, 224, 255));
            }
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            if (!backgroundOverride) {
                this.setBackground(Color.WHITE);
            }
            if (this.unselectedBorder == null) {
                this.unselectedBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, table.getBackground());
            }
            this.setBorder(this.unselectedBorder);
        }
        return this;
    }
}

