/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import mwllactionmapper.ActionPanel;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.keypoller.PollDialog;
import mwllactionmapper.model.KeyModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class KeyPanel
extends JPanel
implements ActionListener {
    private ActionPanel actionPanel;
    private boolean showAnalogOnly = false;
    private boolean isInitializing = false;
    private boolean isEnabled = true;
    private ImageIcon keyIcon;
    private ImageIcon mouseIcon;
    private ImageIcon joyIcon;
    private ImageIcon padIcon;
    private JButton btnPoll;
    private ButtonGroup buttonGroup1;
    private JLabel conflictLabel;
    private JComboBox gamepadBox;
    private JCheckBox gamepadInverseCheckBox;
    private JRadioButton gamepadRadioBtn;
    private JLabel iconLabel;
    private JComboBox joyBox;
    private JCheckBox joyInverseCheckBox;
    private JRadioButton joyRadioBtn;
    private JCheckBox joyRawCheckBox;
    private JComboBox keyboardBox;
    private JRadioButton keyboardRadioBtn;
    private JComboBox mouseBox;
    private JCheckBox mouseInverseCheckBox;
    private JRadioButton mouseRadioBtn;
    private JRadioButton noBindRadioBtn;

    public KeyPanel(String title) {
        this.initComponents();
        this.setConflictLabelText(null);
        this.initSelections();
        this.initActions();
        this.setBorder(BorderFactory.createTitledBorder(title));
    }

    private void initSelections() {
        this.populateKeyboardBindings();
        this.populateMouseBindings();
        this.populateJoystickBindings();
        this.populateGamepadBindings();
        this.updateSelectionUI(SelectedButton.NO_BIND);
    }

    private void initActions() {
        this.noBindRadioBtn.addActionListener(this);
        this.keyboardRadioBtn.addActionListener(this);
        this.keyboardBox.addActionListener(this);
        this.mouseRadioBtn.addActionListener(this);
        this.mouseBox.addActionListener(this);
        this.mouseInverseCheckBox.addActionListener(this);
        this.joyRadioBtn.addActionListener(this);
        this.joyBox.addActionListener(this);
        this.joyInverseCheckBox.addActionListener(this);
        this.joyRawCheckBox.addActionListener(this);
        this.gamepadRadioBtn.addActionListener(this);
        this.gamepadBox.addActionListener(this);
        this.gamepadInverseCheckBox.addActionListener(this);
        this.btnPoll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KeyPanel.this.pollKey();
            }
        });
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            for (Component comp : this.getComponents()) {
                if (comp == this.conflictLabel) continue;
                comp.setEnabled(enabled);
            }
            this.updateUI();
        }
    }

    public void setActionPanel(ActionPanel actionPanel) {
        this.actionPanel = actionPanel;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.noBindRadioBtn = new JRadioButton();
        this.keyboardRadioBtn = new JRadioButton();
        this.mouseRadioBtn = new JRadioButton();
        this.joyRadioBtn = new JRadioButton();
        this.keyboardBox = new JComboBox();
        this.mouseBox = new JComboBox();
        this.joyBox = new JComboBox();
        this.mouseInverseCheckBox = new JCheckBox();
        this.joyInverseCheckBox = new JCheckBox();
        this.joyRawCheckBox = new JCheckBox();
        this.gamepadRadioBtn = new JRadioButton();
        this.gamepadBox = new JComboBox();
        this.gamepadInverseCheckBox = new JCheckBox();
        this.conflictLabel = new JLabel();
        this.btnPoll = new JButton();
        this.iconLabel = new JLabel();
        ResourceMap resourceMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getResourceMap(KeyPanel.class);
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("Form.border.title", new Object[0])));
        this.setName("Form");
        this.buttonGroup1.add(this.noBindRadioBtn);
        this.noBindRadioBtn.setSelected(true);
        this.noBindRadioBtn.setText(resourceMap.getString("noBindRadioBtn.text", new Object[0]));
        this.noBindRadioBtn.setContentAreaFilled(false);
        this.noBindRadioBtn.setName("noBindRadioBtn");
        this.buttonGroup1.add(this.keyboardRadioBtn);
        this.keyboardRadioBtn.setText(resourceMap.getString("keyboardRadioBtn.text", new Object[0]));
        this.keyboardRadioBtn.setContentAreaFilled(false);
        this.keyboardRadioBtn.setName("keyboardRadioBtn");
        this.buttonGroup1.add(this.mouseRadioBtn);
        this.mouseRadioBtn.setText(resourceMap.getString("mouseRadioBtn.text", new Object[0]));
        this.mouseRadioBtn.setContentAreaFilled(false);
        this.mouseRadioBtn.setName("mouseRadioBtn");
        this.buttonGroup1.add(this.joyRadioBtn);
        this.joyRadioBtn.setText(resourceMap.getString("joyRadioBtn.text", new Object[0]));
        this.joyRadioBtn.setContentAreaFilled(false);
        this.joyRadioBtn.setName("joyRadioBtn");
        this.keyboardBox.setMaximumRowCount(20);
        this.keyboardBox.setName("keyboardBox");
        this.mouseBox.setMaximumRowCount(20);
        this.mouseBox.setName("mouseBox");
        this.joyBox.setMaximumRowCount(20);
        this.joyBox.setName("joyBox");
        this.mouseInverseCheckBox.setText(resourceMap.getString("mouseInverseCheckBox.text", new Object[0]));
        this.mouseInverseCheckBox.setContentAreaFilled(false);
        this.mouseInverseCheckBox.setName("mouseInverseCheckBox");
        this.joyInverseCheckBox.setText(resourceMap.getString("joyInverseCheckBox.text", new Object[0]));
        this.joyInverseCheckBox.setContentAreaFilled(false);
        this.joyInverseCheckBox.setName("joyInverseCheckBox");
        this.joyRawCheckBox.setText(resourceMap.getString("joyRawCheckBox.text", new Object[0]));
        this.joyRawCheckBox.setContentAreaFilled(false);
        this.joyRawCheckBox.setName("joyRawCheckBox");
        this.buttonGroup1.add(this.gamepadRadioBtn);
        this.gamepadRadioBtn.setText(resourceMap.getString("gamepadRadioBtn.text", new Object[0]));
        this.gamepadRadioBtn.setContentAreaFilled(false);
        this.gamepadRadioBtn.setName("gamepadRadioBtn");
        this.gamepadBox.setMaximumRowCount(20);
        this.gamepadBox.setName("gamepadBox");
        this.gamepadInverseCheckBox.setText(resourceMap.getString("gamepadInverseCheckBox.text", new Object[0]));
        this.gamepadInverseCheckBox.setContentAreaFilled(false);
        this.gamepadInverseCheckBox.setName("gamepadInverseCheckBox");
        this.conflictLabel.setFont(resourceMap.getFont("conflictLabel.font"));
        this.conflictLabel.setForeground(resourceMap.getColor("conflictLabel.foreground"));
        this.conflictLabel.setText(resourceMap.getString("conflictLabel.text", new Object[0]));
        this.conflictLabel.setName("conflictLabel");
        this.btnPoll.setText(resourceMap.getString("btnPoll.text", new Object[0]));
        this.btnPoll.setName("btnPoll");
        this.iconLabel.setText(resourceMap.getString("iconLabel.text", new Object[0]));
        this.iconLabel.setName("iconLabel");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.conflictLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 354, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noBindRadioBtn).addComponent(this.btnPoll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.iconLabel, -2, 50, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyboardRadioBtn).addComponent(this.mouseRadioBtn).addComponent(this.joyRadioBtn).addComponent(this.gamepadRadioBtn)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyboardBox, -2, 250, -2).addComponent(this.gamepadBox, -2, 250, -2).addComponent(this.mouseBox, -2, 250, -2).addComponent(this.joyBox, -2, 250, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gamepadInverseCheckBox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mouseInverseCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.joyInverseCheckBox, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.joyRawCheckBox))))).addContainerGap(126, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnPoll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noBindRadioBtn)).addComponent(this.iconLabel, -2, 40, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyboardRadioBtn).addComponent(this.keyboardBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mouseRadioBtn).addComponent(this.mouseInverseCheckBox).addComponent(this.mouseBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.joyRadioBtn).addComponent(this.joyInverseCheckBox).addComponent(this.joyBox, -2, -1, -2).addComponent(this.joyRawCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gamepadRadioBtn).addComponent(this.gamepadInverseCheckBox).addComponent(this.gamepadBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.conflictLabel).addContainerGap(155, Short.MAX_VALUE)));
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButton) {
            SelectedButton selection = this.getSelectedButton();
            this.updateSelectionUI(selection);
        } else if (obj instanceof JComboBox) {
            // empty if block
        }
        if (!this.isInitializing) {
            this.updateActionmap();
        }
    }

    private void updateActionmap() {
        if (this.actionPanel == null) {
            return;
        }
        this.actionPanel.updateXML();
        ActionPanel.ActionSelection selectedAction = this.actionPanel.getSelectedAction();
        String selectedDisplayName = selectedAction == null ? "null" : selectedAction.getDisplayName();
        String label = this.getSelectedKeyDisplayName() == null ? "Cleared key for action '" + selectedDisplayName + "'" : "Set '" + this.getSelectedKeyDisplayName() + "' for action '" + selectedDisplayName + "'";
        MWLLActionmapperView.setStatusLabel(label);
    }

    private SelectedButton getSelectedButton() {
        SelectedButton selection = SelectedButton.NO_BIND;
        if (!this.noBindRadioBtn.isSelected()) {
            if (this.keyboardRadioBtn.isSelected()) {
                selection = SelectedButton.KEY_BIND;
            } else if (this.mouseRadioBtn.isSelected()) {
                selection = SelectedButton.MOUSE_BIND;
            } else if (this.joyRadioBtn.isSelected()) {
                selection = SelectedButton.JOY_BIND;
            } else if (this.gamepadRadioBtn.isSelected()) {
                selection = SelectedButton.GAMEPAD_BIND;
            }
        }
        return selection;
    }

    private void updateSelectionUI(SelectedButton selection) {
        if (selection == null) {
            selection = SelectedButton.NO_BIND;
        }
        ImageIcon icon = null;
        boolean isKeyboard = selection.equals((Object)SelectedButton.KEY_BIND);
        if (isKeyboard) {
            if (this.keyIcon == null) {
                this.keyIcon = new ImageIcon(this.getClass().getResource("resources/keyboard icon.png"));
            }
            icon = this.keyIcon;
        }
        this.keyboardBox.setVisible(isKeyboard);
        boolean isMouse = selection.equals((Object)SelectedButton.MOUSE_BIND);
        this.mouseBox.setVisible(isMouse);
        this.mouseInverseCheckBox.setSelected(false);
        this.mouseInverseCheckBox.setVisible(false);
        if (isMouse) {
            if (this.mouseIcon == null) {
                this.mouseIcon = new ImageIcon(this.getClass().getResource("resources/mouse icon.png"));
            }
            icon = this.mouseIcon;
        }
        boolean isJoy = selection.equals((Object)SelectedButton.JOY_BIND);
        this.joyBox.setVisible(isJoy);
        this.joyInverseCheckBox.setVisible(isJoy && this.showAnalogOnly);
        this.joyRawCheckBox.setVisible(isJoy && this.showAnalogOnly);
        if (isJoy) {
            if (this.joyIcon == null) {
                this.joyIcon = new ImageIcon(this.getClass().getResource("resources/joystick icon.png"));
            }
            icon = this.joyIcon;
        }
        boolean isGamepad = selection.equals((Object)SelectedButton.GAMEPAD_BIND);
        this.gamepadBox.setVisible(isGamepad);
        this.gamepadInverseCheckBox.setSelected(false);
        this.gamepadInverseCheckBox.setVisible(false);
        if (isGamepad) {
            if (this.padIcon == null) {
                this.padIcon = new ImageIcon(this.getClass().getResource("resources/gamepad icon.png"));
            }
            icon = this.padIcon;
        }
        this.iconLabel.setIcon(icon);
        this.btnPoll.setVisible(!this.showAnalogOnly);
    }

    private void populateKeyboardBindings() {
        DefaultComboBoxModel model = KeyModel.populateKeyboardBindings();
        model = this.getAnalogFilteredModel(model);
        this.keyboardBox.setModel(model);
    }

    private void populateMouseBindings() {
        DefaultComboBoxModel model = KeyModel.populateMouseBindings();
        model = this.getAnalogFilteredModel(model);
        this.mouseBox.setModel(model);
    }

    private void populateJoystickBindings() {
        DefaultComboBoxModel model = KeyModel.populateJoystickBindings();
        model = this.getAnalogFilteredModel(model);
        this.joyBox.setModel(model);
    }

    private void populateGamepadBindings() {
        DefaultComboBoxModel model = KeyModel.populateGamepadBindings();
        model = this.getAnalogFilteredModel(model);
        this.gamepadBox.setModel(model);
    }

    public void setSelectedKey(String keyName) {
        this.isInitializing = true;
        if (keyName == null || keyName.equals("null")) {
            this.noBindRadioBtn.doClick();
            this.isInitializing = false;
            return;
        }
        boolean isInverted = keyName.contains("inv");
        boolean isRaw = keyName.contains("raw");
        if (isRaw) {
            keyName = keyName.substring(3, keyName.length());
        }
        if (isInverted) {
            keyName = keyName.substring(3, keyName.length());
        }
        if (this.selectModelKey(keyName, (DefaultComboBoxModel)this.keyboardBox.getModel())) {
            this.keyboardRadioBtn.doClick();
        } else if (this.selectModelKey(keyName, (DefaultComboBoxModel)this.mouseBox.getModel())) {
            this.mouseRadioBtn.doClick();
            this.mouseInverseCheckBox.setSelected(isInverted);
        } else if (this.selectModelKey(keyName, (DefaultComboBoxModel)this.joyBox.getModel())) {
            this.joyRadioBtn.doClick();
            this.joyInverseCheckBox.setSelected(isInverted);
            this.joyRawCheckBox.setSelected(isRaw);
        } else if (this.selectModelKey(keyName, (DefaultComboBoxModel)this.gamepadBox.getModel())) {
            this.gamepadRadioBtn.doClick();
            this.gamepadInverseCheckBox.setSelected(isInverted);
        } else {
            this.noBindRadioBtn.doClick();
        }
        this.isInitializing = false;
    }

    private boolean selectModelKey(String keyName, DefaultComboBoxModel model) {
        if (keyName == null || model == null) {
            return false;
        }
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            ControlSelection selection = (ControlSelection)model.getElementAt(i);
            if (!keyName.equals(selection.getKeyName())) continue;
            model.setSelectedItem(selection);
            return true;
        }
        return false;
    }

    public String getSelectedKey() {
        ControlSelection selection = this.getSelectedControl();
        if (selection == null) {
            return null;
        }
        String keyPrepend = "";
        if (this.isRawSelected()) {
            keyPrepend = keyPrepend + "raw";
        }
        if (this.isInvertSelected()) {
            keyPrepend = keyPrepend + "inv";
        }
        return keyPrepend + selection.getKeyName();
    }

    private boolean isRawSelected() {
        SelectedButton selected = this.getSelectedButton();
        boolean rawSelected = false;
        if (selected == SelectedButton.JOY_BIND) {
            rawSelected = this.joyRawCheckBox.isSelected();
        }
        return rawSelected;
    }

    private boolean isInvertSelected() {
        SelectedButton selected = this.getSelectedButton();
        boolean invertSelected = false;
        if (selected == SelectedButton.MOUSE_BIND) {
            invertSelected = this.mouseInverseCheckBox.isSelected();
        } else if (selected == SelectedButton.JOY_BIND) {
            invertSelected = this.joyInverseCheckBox.isSelected();
        } else if (selected == SelectedButton.GAMEPAD_BIND) {
            invertSelected = this.gamepadInverseCheckBox.isSelected();
        }
        return invertSelected;
    }

    public String getSelectedKeyDisplayName() {
        ControlSelection selection = this.getSelectedControl();
        if (selection == null) {
            return null;
        }
        return selection.getDisplayName();
    }

    public ControlSelection getSelectedControl() {
        ControlSelection selection = null;
        SelectedButton selected = this.getSelectedButton();
        if (selected == SelectedButton.KEY_BIND) {
            selection = (ControlSelection)this.keyboardBox.getSelectedItem();
        } else if (selected == SelectedButton.MOUSE_BIND) {
            selection = (ControlSelection)this.mouseBox.getSelectedItem();
        } else if (selected == SelectedButton.JOY_BIND) {
            selection = (ControlSelection)this.joyBox.getSelectedItem();
        } else if (selected == SelectedButton.GAMEPAD_BIND) {
            selection = (ControlSelection)this.gamepadBox.getSelectedItem();
        }
        if (selection == null) {
            return null;
        }
        return selection;
    }

    private DefaultComboBoxModel getAnalogFilteredModel(DefaultComboBoxModel model) {
        if (model == null) {
            return null;
        }
        DefaultComboBoxModel<ControlSelection> filterModel = new DefaultComboBoxModel<ControlSelection>();
        int numElements = model.getSize();
        for (int i = 0; i < numElements; ++i) {
            ControlSelection thisControl = (ControlSelection)model.getElementAt(i);
            if (KeyModel.isKeyAnalog(thisControl.getKeyName())) {
                if (!this.showAnalogOnly) continue;
                filterModel.addElement(thisControl);
                continue;
            }
            if (this.showAnalogOnly) continue;
            filterModel.addElement(thisControl);
        }
        if (this.showAnalogOnly && filterModel.getSize() == 0) {
            filterModel.addElement(new ControlSelection("Analog control only", null));
        } else if (!this.showAnalogOnly && filterModel.getSize() == 0) {
            filterModel.addElement(new ControlSelection("Digital control only", null));
        }
        return filterModel;
    }

    public void setAnalogOnly(boolean analogOnly) {
        if (this.showAnalogOnly != analogOnly) {
            this.showAnalogOnly = analogOnly;
            this.initSelections();
        }
    }

    public void setConflictLabelIcon(ImageIcon icon) {
        this.conflictLabel.setIcon(icon);
    }

    public void setConflictLabelText(String label) {
        this.conflictLabel.setText(label);
    }

    public void pollKey() {
        this.btnPoll.setBackground(Color.GRAY);
        String polledKey = PollDialog.showPollDialog(this.actionPanel.getSelectedAction().getDisplayName());
        if (polledKey != null && !this.isInitializing) {
            this.setSelectedKey(polledKey);
            this.updateActionmap();
            this.actionPanel.updateSelection();
        }
        this.btnPoll.setBackground(null);
    }

    public static class ControlSelection {
        private String displayName;
        private String keyName;

        public ControlSelection(String displayName, String keyName) {
            this.setDisplayName(displayName);
            this.setKeyName(keyName);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectedButton {
        NO_BIND,
        KEY_BIND,
        MOUSE_BIND,
        JOY_BIND,
        GAMEPAD_BIND;

    }
}

