/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper;

import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.JoystickCfgPanel;
import mwllactionmapper.MWLLActionmapperAboutBox;
import mwllactionmapper.MWLLActionmapperApp;
import mwllactionmapper.MappingPanel;
import mwllactionmapper.model.ActionmapsFileModel;
import mwllactionmapper.model.AutoexecModel;
import mwllactionmapper.model.FileCopy;
import mwllactionmapper.model.JoystickCfgModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class MWLLActionmapperView
extends FrameView
implements WindowListener {
    private MappingPanel playerPanel;
    private MappingPanel vehiclePanel;
    private MappingPanel mechPanel;
    private MappingPanel tankPanel;
    private MappingPanel vtolPanel;
    private MappingPanel aerospacePanel;
    private JoystickCfgPanel joyPanel;
    private ActionmapsFileModel.ActionmapsFile workingFile;
    private long workingLastModified;
    private boolean workingHasMissingActions = false;
    public JoystickCfgModel workingJoyCfg;
    public AutoexecModel autoexecModel;
    private File profileDir;
    public static MWLLActionmapperView reference;
    private JList actionmapsList;
    private JButton activeActionmapsBtn;
    private JMenuItem activeMenuItem;
    private JLabel activeStatusLabel;
    private JMenuItem deleteMenuItem;
    private JMenuItem dupeMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPanel mainPanel;
    private JSplitPane mainSplitPane;
    private JTabbedPane mainTabbedPane;
    private JMenuBar menuBar;
    private JButton newActionmapsBtn;
    private JMenuItem newMenuItem;
    private JPopupMenu popMenu;
    private JScrollPane profileScrollPane;
    private JProgressBar progressBar;
    private JMenuItem renameMenuItem;
    private JMenuItem saveMenuItem;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JMenuItem switchProfileItem;
    private JPanel toolbarPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public MWLLActionmapperView(SingleFrameApplication app) {
        super((Application)app);
        try {
            AcrylLookAndFeel.setTheme((String)"Default");
            UIManager.setLookAndFeel("com.jtattoo.plaf.acryl.AcrylLookAndFeel");
        }
        catch (Exception ex) {
            // empty catch block
        }
        reference = this;
        this.autoexecModel = new AutoexecModel();
        this.autoexecModel.importAutoexecCfgFile();
        this.initComponents();
        try {
            this.getFrame().setIconImage(new ImageIcon(this.getClass().getResource("resources/mwll.gif")).getImage());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initPanels();
        this.doSelectProfile();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MWLLActionmapperView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MWLLActionmapperView.this.busyIconIndex = (MWLLActionmapperView.this.busyIconIndex + 1) % MWLLActionmapperView.this.busyIcons.length;
                MWLLActionmapperView.this.statusAnimationLabel.setIcon(MWLLActionmapperView.this.busyIcons[MWLLActionmapperView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        this.addActionmapsListSelectionHandlers();
        ComplexCellRenderer renderer = new ComplexCellRenderer();
        this.actionmapsList.setCellRenderer(renderer);
        this.getFrame().setBounds(0, 0, 1000, 600);
        this.getFrame().addWindowListener(this);
    }

    private void addActionmapsListSelectionHandlers() {
        this.actionmapsList.addListSelectionListener(new ListSelectionListener(){
            private ActionmapsFileModel.ActionmapsFile debounceSelection;

            public void valueChanged(ListSelectionEvent e) {
                Object selObj;
                Object obj = e.getSource();
                if (obj == MWLLActionmapperView.this.actionmapsList && (selObj = MWLLActionmapperView.this.actionmapsList.getSelectedValue()) instanceof ActionmapsFileModel.ActionmapsFile) {
                    ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)selObj;
                    if (this.debounceSelection != null && this.debounceSelection.getActionmapsName().equals(actionmaps.getActionmapsName())) {
                        return;
                    }
                    this.debounceSelection = actionmaps;
                    MWLLActionmapperView.this.doOpen(actionmaps);
                }
            }
        });
        this.actionmapsList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Object selObj;
                if (e.getSource() == MWLLActionmapperView.this.actionmapsList && e.getButton() != 1 && (selObj = MWLLActionmapperView.this.actionmapsList.getSelectedValue()) instanceof ActionmapsFileModel.ActionmapsFile && !MWLLActionmapperView.this.actionmapsList.isSelectionEmpty() && MWLLActionmapperView.this.actionmapsList.locationToIndex(e.getPoint()) == MWLLActionmapperView.this.actionmapsList.getSelectedIndex()) {
                    MWLLActionmapperView.this.popMenu.show(MWLLActionmapperView.this.actionmapsList, e.getX() + 5, e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    @Action
    public void setActive() {
        Object selObj = this.actionmapsList.getSelectedValue();
        if (selObj instanceof ActionmapsFileModel.ActionmapsFile) {
            ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)selObj;
            ActionmapsFileModel.setActiveActionmaps(actionmaps, this.profileDir);
            MWLLActionmapperView.setStatusLabel("Set active actionmaps '" + actionmaps.getActionmapsName() + "'.");
            JOptionPane.showMessageDialog(this.getFrame(), "Active actionmaps set to '" + actionmaps.getActionmapsName() + "'.", "Active actionmaps set", 1);
            this.updateProfileActionmapsList();
            this.workingFile = this.selectActionmapsOnList(null);
            this.doSave();
        }
    }

    @Action
    public void doDelete() {
        Object selObj = this.actionmapsList.getSelectedValue();
        if (selObj instanceof ActionmapsFileModel.ActionmapsFile) {
            ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)selObj;
            if (actionmaps.isActive()) {
                JOptionPane.showMessageDialog(this.getFrame(), "This actionmaps is still active and cannot be deleted", "Make another actionmaps active to delete", 0);
                return;
            }
            if (JOptionPane.showConfirmDialog(this.getFrame(), "Are you sure you want to delete '" + actionmaps.getActionmapsName() + "'?", "Delete this actionmaps?", 2, 3) == 0) {
                if (actionmaps.getFile().delete()) {
                    this.workingFile = null;
                    this.getJoystickCfgFile(actionmaps, false).delete();
                    MWLLActionmapperView.setStatusLabel("Deleted file '" + actionmaps.getActionmapsName() + "'.");
                    this.updateProfileActionmapsList();
                    this.selectActionmapsOnList(null);
                } else {
                    MWLLActionmapperView.setStatusLabel("Error deleting file");
                }
            }
        }
    }

    @Action
    public void doRename() {
        Object selObj = this.actionmapsList.getSelectedValue();
        if (selObj instanceof ActionmapsFileModel.ActionmapsFile) {
            ActionmapsFileModel.ActionmapsFile newActionmaps;
            ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)selObj;
            if (this.workingFile != null && this.workingFile.isModified() && JOptionPane.showConfirmDialog(this.getFrame(), "Save changes made to this actionmaps before renaming?\n", "Save changes before renaming?", 0, 3) == 0) {
                this.doSave();
            }
            if ((newActionmaps = this.showActionmapsNameDialog(actionmaps.getActionmapsName())) != null) {
                if (actionmaps.getFile().renameTo(newActionmaps.getFile())) {
                    this.getJoystickCfgFile(actionmaps, true).renameTo(this.getJoystickCfgFile(newActionmaps, true));
                    MWLLActionmapperView.setStatusLabel("Renamed file to '" + newActionmaps.getActionmapsName() + "'.");
                    if (actionmaps.isActive()) {
                        ActionmapsFileModel.setActiveActionmaps(newActionmaps, this.profileDir);
                    }
                    this.updateProfileActionmapsList();
                    this.selectActionmapsOnList(newActionmaps);
                } else {
                    MWLLActionmapperView.setStatusLabel("Error renaming file");
                }
            }
        }
    }

    @Action
    public void doDuplicate() {
        Object selObj = this.actionmapsList.getSelectedValue();
        if (selObj instanceof ActionmapsFileModel.ActionmapsFile) {
            ActionmapsFileModel.ActionmapsFile newActionmaps;
            ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)selObj;
            if (this.workingFile != null && this.workingFile.isModified() && JOptionPane.showConfirmDialog(this.getFrame(), "Save changes made to this actionmaps before duplicating?\n", "Save changes before duplicating?", 0, 3) == 0) {
                this.doSave();
            }
            if ((newActionmaps = this.showActionmapsNameDialog(null)) != null) {
                try {
                    MWLLActionmapperView.setStatusLabel("Duplicating file");
                    FileCopy.copy(actionmaps.getFile().getAbsolutePath(), newActionmaps.getFile().getAbsolutePath());
                    MWLLActionmapperView.setStatusLabel("Finished duplicating file to '" + newActionmaps.getActionmapsName() + "'.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MWLLActionmapperView.setStatusLabel("Error duplicating file");
                }
                this.updateProfileActionmapsList();
                this.selectActionmapsOnList(newActionmaps);
            }
        }
    }

    @Action
    public void doSave() {
        if (this.workingFile != null) {
            this.statusMessageLabel.setText("Saving...");
            ActionMaps.exportActionMaps(this.workingFile.getFile());
            this.workingJoyCfg.exportJoystickCfg(this.getJoystickCfgFile(this.workingFile, true));
            this.autoexecModel.exportAutoexecCfg();
            this.workingLastModified = this.workingFile.lastModified();
            this.workingFile.setModified(false);
            if (this.workingFile.isActive()) {
                ActionmapsFileModel.setActiveActionmaps(this.workingFile, this.profileDir);
            }
            this.statusMessageLabel.setText("Finished saving " + this.workingFile.getFile().getName() + ".");
            this.setAllActionSelectionsNotModified();
            this.updateProfileActionmapsList();
            this.selectActionmapsOnList(this.workingFile);
        }
    }

    @Action
    public void doOpen(ActionmapsFileModel.ActionmapsFile actionmapsFile) {
        if (actionmapsFile != null) {
            if (this.workingFile != null && this.workingFile.isModified() && JOptionPane.showConfirmDialog(this.getFrame(), "Save changes made to this actionmaps before loading another?\n", "Save changes before loading another actionmaps?", 0, 3) == 0) {
                this.doSave();
            }
            this.workingJoyCfg = new JoystickCfgModel();
            this.workingJoyCfg.importJoystickCfgFile(this.getJoystickCfgFile(actionmapsFile, false));
            this.joyPanel.reloadSettings();
            this.workingFile = actionmapsFile;
            this.workingLastModified = actionmapsFile.lastModified();
            this.statusMessageLabel.setText("Loading...");
            ActionMaps.importActionMaps(this.workingFile.getFile());
            this.statusMessageLabel.setText("Successfully loaded " + this.workingFile.getFile().getName() + ".");
            this.performAllConflictChecks();
            this.setAllActionSelectionsNotModified();
            this.updateActionTableBinds();
            this.deselectAllActions();
            this.updateActiveStatusLabel(actionmapsFile);
            if (this.workingHasMissingActions) {
                URL imgURL = this.getClass().getResource("resources/question-big.png");
                ImageIcon icon = new ImageIcon(imgURL);
                JOptionPane.showMessageDialog(this.getFrame(), "At least one action was not detected in the selected actionmaps file: '" + this.workingFile.getActionmapsName() + "'\n" + "These missing actions will be highlighted and placed next to a '?' icon.\n\n" + "You will be unable to configure any actions determined to be missing.\n" + "        Note: Use the 'File -> New Actionmaps' menu option to have an actionmaps created\n" + "        that has all necessary actions present.\n\n", "Missing actions detected!", 2, icon);
            }
        }
    }

    private void updateActiveStatusLabel(ActionmapsFileModel.ActionmapsFile actionmapsFile) {
        if (actionmapsFile == null) {
            this.activeStatusLabel.setText(null);
            return;
        }
        String statusText = "Actionmap \"" + actionmapsFile.getActionmapsName() + "\"";
        ImageIcon icon = null;
        if (actionmapsFile.isActive()) {
            statusText = statusText + " is currently set active";
            URL imgURL = this.getClass().getResource("resources/active.png");
            icon = new ImageIcon(imgURL);
        } else {
            statusText = statusText + " is not set active";
            URL imgURL = this.getClass().getResource("resources/twisty_right.png");
            icon = new ImageIcon(imgURL);
        }
        this.activeStatusLabel.setText(statusText);
        this.activeActionmapsBtn.setIcon(icon);
    }

    private File getJoystickCfgFile(ActionmapsFileModel.ActionmapsFile actionmapsFile, boolean saveFlag) {
        if (actionmapsFile == null) {
            return null;
        }
        File joyCfgFile = new File(actionmapsFile.getFile().getParentFile(), "joystick_" + actionmapsFile.getActionmapsName() + ".cfg");
        if (!saveFlag && !joyCfgFile.exists()) {
            File activeJoyCfgFile = new File(actionmapsFile.getFile().getParentFile(), "joystick.cfg");
            if (!activeJoyCfgFile.exists()) {
                JoystickCfgModel newDefaultJoyCfg = new JoystickCfgModel();
                newDefaultJoyCfg.importJoystickCfgDefault();
                newDefaultJoyCfg.exportJoystickCfg(activeJoyCfgFile);
            }
            try {
                FileCopy.copy(activeJoyCfgFile.getAbsolutePath(), joyCfgFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return joyCfgFile;
    }

    private ActionmapsFileModel.ActionmapsFile showActionmapsNameDialog(String initialName) {
        ActionmapsFileModel.ActionmapsFile actionmaps = null;
        while (actionmaps == null) {
            Object input = JOptionPane.showInputDialog(this.getFrame(), "Please enter a name for the actionmaps:\n", "Enter a name", 3, null, null, initialName);
            if (input instanceof String) {
                String inputName = ((String)input).trim();
                if (inputName.equals(initialName)) {
                    return null;
                }
                if (inputName.length() == 0) continue;
                if (inputName.contains("_")) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Actionmaps name may not included the '_' character since it is reserved for internal use.", "Name may not include the '_' character", 0);
                    continue;
                }
                if (inputName.contains("active")) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Actionmaps name may not included the word 'active' since it is reserved for internal use.", "Name may not include the word 'active'", 0);
                    continue;
                }
                List<ActionmapsFileModel.ActionmapsFile> fileList = ActionmapsFileModel.getProfileActionmapsFiles(this.profileDir);
                boolean nameAlreadyInUse = false;
                for (ActionmapsFileModel.ActionmapsFile thisActionmaps : fileList) {
                    if (!thisActionmaps.getActionmapsName().equals(inputName)) continue;
                    nameAlreadyInUse = true;
                    break;
                }
                if (nameAlreadyInUse) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Actionmaps name is already in use, please enter another name.", "Actionmaps name already in use", 0);
                    continue;
                }
                String fileName = ActionmapsFileModel.createActionmapsFileName(false, inputName);
                try {
                    File.createTempFile(fileName, null);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Actionmaps name cannot be created due to usage of Operating System reserved characters\n\nPlease enter another name.", "Actionmaps name cannot be created", 0);
                    continue;
                }
                actionmaps = new ActionmapsFileModel.ActionmapsFile(new File(this.profileDir, fileName));
                continue;
            }
            return null;
        }
        return actionmaps;
    }

    @Action
    public void doNew() {
        ActionmapsFileModel.ActionmapsFile actionmaps;
        if (this.workingFile != null && this.workingFile.isModified() && JOptionPane.showConfirmDialog(this.getFrame(), "Save changes made to this actionmaps before creating a new one?\n", "Save changes before creating a new actionmaps?", 0, 3) == 0) {
            this.doSave();
        }
        if ((actionmaps = this.showActionmapsNameDialog(null)) == null) {
            return;
        }
        try {
            this.statusMessageLabel.setText("Creating new actionmaps from default...");
            ActionMaps.importActionMapsFromStream(this.getClass().getResourceAsStream("resources/actionmaps_default.xml"));
            this.statusMessageLabel.setText("New actionmaps created from default.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusMessageLabel.setText("Error creating new!");
            return;
        }
        this.workingJoyCfg = new JoystickCfgModel();
        this.workingJoyCfg.importJoystickCfgDefault();
        this.joyPanel.reloadSettings();
        this.workingFile = actionmaps;
        this.workingLastModified = actionmaps.lastModified();
        this.doSave();
        this.performAllConflictChecks();
        this.setAllActionSelectionsNotModified();
        this.updateActionTableBinds();
        this.deselectAllActions();
        this.updateProfileActionmapsList();
        this.selectActionmapsOnList(actionmaps);
    }

    public static void setStatusLabel(String label) {
        MWLLActionmapperView.reference.statusMessageLabel.setText(label);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MWLLActionmapperApp.getApplication().getMainFrame();
            this.aboutBox = new MWLLActionmapperAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MWLLActionmapperApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void doSelectProfile() {
        List<File> profiles = ActionmapsFileModel.getMWLLProfiles();
        if (profiles.isEmpty()) {
            this.profileDir = null;
            JOptionPane.showMessageDialog(this.getFrame(), "No profiles found in My Documents\\" + ActionmapsFileModel.MWLL_PROFILES_LOCATION + ".\n\n" + "You must create a new Profile in Crysis before using this application.\n", "No profiles found, exiting!", 0);
            System.exit(0);
        } else if (profiles.size() == 1) {
            this.profileDir = profiles.get(0);
            JOptionPane.showMessageDialog(this.getFrame(), "Automatically selected profile '" + this.profileDir.getName() + "'", "Selected " + this.profileDir.getName(), 1);
        } else {
            Object selection;
            int i;
            Object[] profileArray = new Object[profiles.size()];
            String paramSelectProfile = null;
            String preSelectProfile = null;
            if (MWLLActionmapperApp.args != null && MWLLActionmapperApp.args.length > 0) {
                for (i = 0; i < MWLLActionmapperApp.args.length; ++i) {
                    String argStr = MWLLActionmapperApp.args[i];
                    if (!argStr.startsWith("-profile")) continue;
                    paramSelectProfile = argStr.substring(argStr.indexOf("=") + 1).replaceAll("\"", "");
                    MWLLActionmapperApp.args[i] = "";
                }
            }
            for (i = 0; i < profiles.size(); ++i) {
                String profileName = profiles.get(i).getName();
                if (!profileName.equals(paramSelectProfile)) continue;
                preSelectProfile = profileName;
                break;
            }
            if (preSelectProfile == null) {
                String selectedProfile = null;
                for (int i2 = 0; i2 < profiles.size(); ++i2) {
                    profileArray[i2] = profiles.get(i2).getName();
                    if (!profiles.get(i2).equals(this.profileDir)) continue;
                    selectedProfile = profiles.get(i2).getName();
                }
                selection = JOptionPane.showInputDialog(this.getFrame(), "Please choose a profile.", "Select a profile", 3, null, profileArray, selectedProfile);
            } else {
                selection = preSelectProfile;
            }
            if (selection instanceof String) {
                String selStr = (String)selection;
                for (File thisProfile : profiles) {
                    if (!selStr.equals(thisProfile.getName())) continue;
                    this.profileDir = thisProfile;
                    break;
                }
            }
            if (this.profileDir == null) {
                System.exit(0);
            }
        }
        this.updateProfileActionmapsList();
        this.autoSelectActiveActionmaps();
    }

    private void updateActionTableBinds() {
        this.playerPanel.updateActionTableBinds();
        this.vehiclePanel.updateActionTableBinds();
        this.mechPanel.updateActionTableBinds();
        this.tankPanel.updateActionTableBinds();
        this.vtolPanel.updateActionTableBinds();
        this.aerospacePanel.updateActionTableBinds();
    }

    private void deselectAllActions() {
        this.playerPanel.deselectAction();
        this.vehiclePanel.deselectAction();
        this.mechPanel.deselectAction();
        this.tankPanel.deselectAction();
        this.vtolPanel.deselectAction();
        this.aerospacePanel.deselectAction();
    }

    public void setWorkingFileModified(boolean modified) {
        if (this.workingFile != null) {
            String titleStr = null;
            if (modified) {
                long lastModified = this.workingFile.lastModified();
                if (this.workingLastModified != lastModified) {
                    int response = JOptionPane.showConfirmDialog(this.getFrame(), "The actionmaps file currently being edited has been modified outside of this application.\n\nWould you like to revert any recently made changes and open the new version?\n    - Press 'Yes' to open the new version, but lose all recently made changes.\n    - Press 'No' to continue making changes for the file in memory.\n\n", "Actionmaps file modified outside of this application, revert changes and open?", 0, 2);
                    this.workingLastModified = lastModified;
                    if (response == 0) {
                        this.setWorkingFileModified(false);
                        this.doOpen(this.workingFile);
                        return;
                    }
                }
                titleStr = "MWLL Actionmapper - * Modified * " + this.workingFile.getActionmapsName();
            } else {
                titleStr = "MWLL Actionmapper - " + this.workingFile.getActionmapsName();
            }
            if (this.workingFile.isActive()) {
                titleStr = titleStr + " (Active)";
            }
            this.getFrame().setTitle(titleStr);
            DefaultListModel model = (DefaultListModel)this.actionmapsList.getModel();
            this.workingFile.setModified(modified);
            for (int i = 0; i < model.size(); ++i) {
                Object obj = model.get(i);
                if (!(obj instanceof ActionmapsFileModel.ActionmapsFile)) continue;
                ActionmapsFileModel.ActionmapsFile thisActionmaps = (ActionmapsFileModel.ActionmapsFile)obj;
                if (!this.workingFile.getActionmapsName().equals(thisActionmaps.getActionmapsName())) continue;
                thisActionmaps.setModified(modified);
                break;
            }
            this.saveMenuItem.setEnabled(modified);
            this.actionmapsList.updateUI();
        }
    }

    private void setAllActionSelectionsNotModified() {
        this.playerPanel.setAllActionSelectionsNotModified();
        this.vehiclePanel.setAllActionSelectionsNotModified();
        this.mechPanel.setAllActionSelectionsNotModified();
        this.tankPanel.setAllActionSelectionsNotModified();
        this.vtolPanel.setAllActionSelectionsNotModified();
        this.aerospacePanel.setAllActionSelectionsNotModified();
        this.joyPanel.reloadSettings();
        DefaultListModel model = (DefaultListModel)this.actionmapsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            Object obj = model.get(i);
            if (!(obj instanceof ActionmapsFileModel.ActionmapsFile)) continue;
            ActionmapsFileModel.ActionmapsFile thisActionmaps = (ActionmapsFileModel.ActionmapsFile)obj;
            thisActionmaps.setModified(false);
        }
        this.saveMenuItem.setEnabled(false);
        this.setWorkingFileModified(false);
        this.actionmapsList.updateUI();
    }

    private void performAllConflictChecks() {
        this.setWorkingHasMissingActions(false);
        this.playerPanel.performConflictCheck();
        this.vehiclePanel.performConflictCheck();
        this.mechPanel.performConflictCheck();
        this.tankPanel.performConflictCheck();
        this.vtolPanel.performConflictCheck();
        this.aerospacePanel.performConflictCheck();
    }

    private void autoSelectActiveActionmaps() {
        List<ActionmapsFileModel.ActionmapsFile> actionmaps = ActionmapsFileModel.getProfileActionmapsFiles(this.profileDir);
        for (ActionmapsFileModel.ActionmapsFile thisActionmaps : actionmaps) {
            if (!thisActionmaps.isActive()) continue;
            this.doOpen(thisActionmaps);
            return;
        }
    }

    private void updateProfileActionmapsList() {
        DefaultListModel<ActionmapsFileModel.ActionmapsFile> model = new DefaultListModel<ActionmapsFileModel.ActionmapsFile>();
        List<ActionmapsFileModel.ActionmapsFile> actionmaps = ActionmapsFileModel.getProfileActionmapsFiles(this.profileDir);
        if (actionmaps.isEmpty() && (actionmaps = ActionmapsFileModel.performFirstTimeActionmapsOps(this.profileDir)).isEmpty()) {
            JOptionPane.showMessageDialog(this.getFrame(), "No actionmaps files found in profile '" + this.profileDir.getName() + "'", "No actionmaps files found", 0);
            this.doSelectProfile();
            return;
        }
        for (ActionmapsFileModel.ActionmapsFile thisActionmaps : actionmaps) {
            model.addElement(thisActionmaps);
        }
        JPanel profileHeaderPanel = new JPanel();
        profileHeaderPanel.setBackground(Color.LIGHT_GRAY);
        profileHeaderPanel.setCursor(new Cursor(0));
        JLabel profileHeaderLbl = new JLabel(this.profileDir.getName());
        profileHeaderLbl.setCursor(new Cursor(0));
        profileHeaderPanel.add(profileHeaderLbl);
        this.profileScrollPane.setColumnHeaderView(profileHeaderPanel);
        this.profileScrollPane.updateUI();
        this.actionmapsList.setModel(model);
    }

    public void setWorkingHasMissingActions(boolean workingHasMissingActions) {
        this.workingHasMissingActions = workingHasMissingActions;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mainSplitPane = new JSplitPane();
        this.profileScrollPane = new JScrollPane();
        this.actionmapsList = new JList();
        this.mainTabbedPane = new JTabbedPane();
        this.toolbarPanel = new JPanel();
        this.newActionmapsBtn = new JButton();
        this.activeStatusLabel = new JLabel();
        this.activeActionmapsBtn = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.switchProfileItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.newMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.popMenu = new JPopupMenu();
        this.activeMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.dupeMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.deleteMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.mainSplitPane.setDividerLocation(150);
        this.mainSplitPane.setName("mainSplitPane");
        this.profileScrollPane.setCursor(new Cursor(12));
        this.profileScrollPane.setName("profileScrollPane");
        this.actionmapsList.setSelectionMode(0);
        this.actionmapsList.setCursor(new Cursor(0));
        this.actionmapsList.setName("actionmapsList");
        this.profileScrollPane.setViewportView(this.actionmapsList);
        this.mainSplitPane.setLeftComponent(this.profileScrollPane);
        this.mainTabbedPane.setName("mainTabbedPane");
        this.mainSplitPane.setRightComponent(this.mainTabbedPane);
        this.toolbarPanel.setName("toolbarPanel");
        ResourceMap resourceMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getResourceMap(MWLLActionmapperView.class);
        this.newActionmapsBtn.setText(resourceMap.getString("newActionmapsBtn.text", new Object[0]));
        this.newActionmapsBtn.setToolTipText(resourceMap.getString("newActionmapsBtn.toolTipText", new Object[0]));
        this.newActionmapsBtn.setCursor(new Cursor(12));
        this.newActionmapsBtn.setFocusable(false);
        this.newActionmapsBtn.setHorizontalTextPosition(0);
        this.newActionmapsBtn.setName("newActionmapsBtn");
        this.newActionmapsBtn.setVerticalTextPosition(3);
        this.newActionmapsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MWLLActionmapperView.this.newActionmapsBtnActionPerformed(evt);
            }
        });
        this.activeStatusLabel.setText(resourceMap.getString("activeStatusLabel.text", new Object[0]));
        this.activeStatusLabel.setName("activeStatusLabel");
        this.activeActionmapsBtn.setForeground(resourceMap.getColor("activeActionmapsBtn.foreground"));
        this.activeActionmapsBtn.setText(resourceMap.getString("activeActionmapsBtn.text", new Object[0]));
        this.activeActionmapsBtn.setToolTipText(resourceMap.getString("activeActionmapsBtn.toolTipText", new Object[0]));
        this.activeActionmapsBtn.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, resourceMap.getColor("activeActionmapsBtn.border.matteColor")));
        this.activeActionmapsBtn.setContentAreaFilled(false);
        this.activeActionmapsBtn.setCursor(new Cursor(12));
        this.activeActionmapsBtn.setFocusable(false);
        this.activeActionmapsBtn.setHorizontalAlignment(11);
        this.activeActionmapsBtn.setName("activeActionmapsBtn");
        this.activeActionmapsBtn.setVerticalTextPosition(3);
        this.activeActionmapsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MWLLActionmapperView.this.activeActionmapsBtnActionPerformed(evt);
            }
        });
        GroupLayout toolbarPanelLayout = new GroupLayout(this.toolbarPanel);
        this.toolbarPanel.setLayout(toolbarPanelLayout);
        toolbarPanelLayout.setHorizontalGroup(toolbarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(toolbarPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.newActionmapsBtn).addGap(18, 18, 18).addComponent(this.activeStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.activeActionmapsBtn).addContainerGap(637, Short.MAX_VALUE)));
        toolbarPanelLayout.setVerticalGroup(toolbarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(toolbarPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.activeActionmapsBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.activeStatusLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.newActionmapsBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolbarPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainSplitPane, -1, 858, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.toolbarPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainSplitPane, -1, 493, Short.MAX_VALUE)));
        this.menuBar.setBackground(resourceMap.getColor("menuBar.background"));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = ((MWLLActionmapperApp)Application.getInstance(MWLLActionmapperApp.class)).getContext().getActionMap(MWLLActionmapperView.class, (Object)this);
        this.switchProfileItem.setAction(actionMap.get("doSelectProfile"));
        this.switchProfileItem.setText(resourceMap.getString("switchProfileItem.text", new Object[0]));
        this.switchProfileItem.setName("switchProfileItem");
        fileMenu.add(this.switchProfileItem);
        this.jSeparator3.setName("jSeparator3");
        fileMenu.add(this.jSeparator3);
        this.newMenuItem.setAction(actionMap.get("doNew"));
        this.newMenuItem.setText(resourceMap.getString("newMenuItem.text", new Object[0]));
        this.newMenuItem.setName("newMenuItem");
        fileMenu.add(this.newMenuItem);
        this.saveMenuItem.setAction(actionMap.get("doSave"));
        this.saveMenuItem.setText(resourceMap.getString("saveMenuItem.text", new Object[0]));
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 858, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 688, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.popMenu.setName("popMenu");
        this.activeMenuItem.setAction(actionMap.get("setActive"));
        this.activeMenuItem.setIcon(resourceMap.getIcon("activeMenuItem.icon"));
        this.activeMenuItem.setText(resourceMap.getString("activeMenuItem.text", new Object[0]));
        this.activeMenuItem.setName("activeMenuItem");
        this.popMenu.add(this.activeMenuItem);
        this.jSeparator4.setName("jSeparator4");
        this.popMenu.add(this.jSeparator4);
        this.dupeMenuItem.setAction(actionMap.get("doDuplicate"));
        this.dupeMenuItem.setText(resourceMap.getString("dupeMenuItem.text", new Object[0]));
        this.dupeMenuItem.setName("dupeMenuItem");
        this.popMenu.add(this.dupeMenuItem);
        this.renameMenuItem.setAction(actionMap.get("doRename"));
        this.renameMenuItem.setText(resourceMap.getString("renameMenuItem.text", new Object[0]));
        this.renameMenuItem.setName("renameMenuItem");
        this.popMenu.add(this.renameMenuItem);
        this.jSeparator2.setName("jSeparator2");
        this.popMenu.add(this.jSeparator2);
        this.deleteMenuItem.setAction(actionMap.get("doDelete"));
        this.deleteMenuItem.setText(resourceMap.getString("deleteMenuItem.text", new Object[0]));
        this.deleteMenuItem.setName("deleteMenuItem");
        this.popMenu.add(this.deleteMenuItem);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void activeActionmapsBtnActionPerformed(ActionEvent evt) {
        this.setActive();
    }

    private void newActionmapsBtnActionPerformed(ActionEvent evt) {
        this.doNew();
    }

    private void initPanels() {
        this.playerPanel = new MappingPanel(MappingPanel.PanelType.PLAYER);
        this.vehiclePanel = new MappingPanel(MappingPanel.PanelType.VEHICLE);
        this.mechPanel = new MappingPanel(MappingPanel.PanelType.MECH);
        this.tankPanel = new MappingPanel(MappingPanel.PanelType.TANK);
        this.vtolPanel = new MappingPanel(MappingPanel.PanelType.VTOL);
        this.aerospacePanel = new MappingPanel(MappingPanel.PanelType.AEROSPACE);
        this.joyPanel = new JoystickCfgPanel();
        this.mainTabbedPane.add("Player", this.playerPanel);
        this.mainTabbedPane.add("Vehicle", this.vehiclePanel);
        this.mainTabbedPane.add("Mech", this.mechPanel);
        this.mainTabbedPane.add("Tank", this.tankPanel);
        this.mainTabbedPane.add("VTOL", this.vtolPanel);
        this.mainTabbedPane.add("Aerospace", this.aerospacePanel);
        this.mainTabbedPane.add("Joystick Settings", this.joyPanel);
        this.mainTabbedPane.setSelectedComponent(this.playerPanel);
    }

    private ActionmapsFileModel.ActionmapsFile selectActionmapsOnList(ActionmapsFileModel.ActionmapsFile actionmapsFile) {
        DefaultListModel model = (DefaultListModel)this.actionmapsList.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!(model.get(i) instanceof ActionmapsFileModel.ActionmapsFile)) continue;
            ActionmapsFileModel.ActionmapsFile thisActionmaps = (ActionmapsFileModel.ActionmapsFile)model.get(i);
            if (actionmapsFile == null) {
                if (!thisActionmaps.isActive()) continue;
                this.actionmapsList.setSelectedValue(thisActionmaps, true);
                this.updateActiveStatusLabel(thisActionmaps);
                return thisActionmaps;
            }
            if (!thisActionmaps.getActionmapsName().equals(actionmapsFile.getActionmapsName())) continue;
            this.actionmapsList.setSelectedValue(thisActionmaps, true);
            this.updateActiveStatusLabel(thisActionmaps);
            return thisActionmaps;
        }
        return null;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        int answer;
        if (this.workingFile != null && this.workingFile.isModified() && (answer = JOptionPane.showConfirmDialog(this.getFrame(), "Save changes before closing?\n", "Save changes first?", 0, 3)) == 0) {
            this.doSave();
            JOptionPane.showMessageDialog(this.getFrame(), "Saved! Now Exiting.", "Saved!", 1);
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class ComplexCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        Border unselectedBorder = null;
        Border selectedBorder = null;

        ComplexCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color theForeground = Color.BLACK;
            String theText = null;
            ImageIcon icon = null;
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ActionmapsFileModel.ActionmapsFile) {
                ActionmapsFileModel.ActionmapsFile actionmaps = (ActionmapsFileModel.ActionmapsFile)value;
                theText = actionmaps.toString();
                if (actionmaps.isModified()) {
                    URL imgURL = this.getClass().getResource("resources/modified.png");
                    theForeground = Color.BLUE;
                    icon = new ImageIcon(imgURL);
                } else if (actionmaps.isActive()) {
                    URL imgURL = this.getClass().getResource("resources/active.png");
                    icon = new ImageIcon(imgURL);
                }
            } else if (value != null) {
                theText = value.toString();
            }
            if (isSelected) {
                renderer.setForeground(Color.BLACK);
                renderer.setBackground(new Color(200, 224, 255));
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, list.getSelectionBackground());
                }
                renderer.setBorder(this.selectedBorder);
            } else {
                renderer.setForeground(theForeground);
                renderer.setBackground(Color.WHITE);
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, list.getBackground());
                }
                renderer.setBorder(this.unselectedBorder);
            }
            renderer.setText(theText);
            renderer.setIcon(icon);
            return renderer;
        }
    }
}

