/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.enums;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import mwllactionmapper.enums.IControlSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyControlSelection implements IControlSelection
{
    KEY_UNKNOWN(null, null, new String[0]),
    KEY_1("1", "1", "1"),
    KEY_2("2", "2", "2"),
    KEY_3("3", "3", "3"),
    KEY_4("4", "4", "4"),
    KEY_5("5", "5", "5"),
    KEY_6("6", "6", "6"),
    KEY_7("7", "7", "7"),
    KEY_8("8", "8", "8"),
    KEY_9("9", "9", "9"),
    KEY_0("0", "0", "0"),
    KEY_N1("Numpad 1", "np_1", "Num 1"),
    KEY_N2("Numpad 2", "np_2", "Num 2"),
    KEY_N3("Numpad 3", "np_3", "Num 3"),
    KEY_N4("Numpad 4", "np_4", "Num 4"),
    KEY_N5("Numpad 5", "np_5", "Num 5"),
    KEY_N6("Numpad 6", "np_6", "Num 6"),
    KEY_N7("Numpad 7", "np_7", "Num 7"),
    KEY_N8("Numpad 8", "np_8", "Num 8"),
    KEY_N9("Numpad 9", "np_9", "Num 9"),
    KEY_N0("Numpad 0", "np_0", "Num 0"),
    KEY_F1("f1", "f1", "F1"),
    KEY_F2("f2", "f2", "F2"),
    KEY_F3("f3", "f3", "F3"),
    KEY_F4("f4", "f4", "F4"),
    KEY_F5("f5", "f5", "F5"),
    KEY_F6("f6", "f6", "F6"),
    KEY_F7("f7", "f7", "F7"),
    KEY_F8("f8", "f8", "F8"),
    KEY_F9("f9", "f9", "F9"),
    KEY_F10("f10", "f10", "F10"),
    KEY_F11("f11", "f11", "F11"),
    KEY_F12("f12", "f12", "F12"),
    KEY_N_SLASH("Numpad /", "np_divide", "Num /"),
    KEY_N_AST("Numpad *", "np_multiply", "Multiply"),
    KEY_N_SUB("Numpad -", "np_subtract", "Num -"),
    KEY_N_ADD("Numpad +", "np_add", "Num +"),
    KEY_N_ENT("Numpad Enter", "np_enter", new String[0]),
    KEY_N_PER("Numpad .", "np_period", new String[0]),
    KEY_ENTER("Enter", "enter", "Return"),
    KEY_LCTRL("Left Control", "lctrl", "Left Control"),
    KEY_RCTRL("Right Control", "rctrl", "Right Control"),
    KEY_LALT("Left Alt", "lalt", "Left Alt"),
    KEY_RALT("Right Alt", "ralt", "Right Alt"),
    KEY_LSHIFT("Left Shift", "lshift", "Left Shift"),
    KEY_RSHIFT("Right Shift", "rshift", "Right Shift"),
    KEY_BACKSPACE("Backspace", "backspace", "Back"),
    KEY_HOME("Home", "home", "Home"),
    KEY_END("End", "end", "End"),
    KEY_INS("Insert", "insert", "Insert"),
    KEY_DEL("Delete", "delete", "Delete"),
    KEY_PGUP("Page Up", "pgup", "Pg Up"),
    KEY_PGDN("Page Down", "pgdn", "Pg Down"),
    KEY_SPACE("Spacebar", "space", " "),
    KEY_UP("Up", "up", "Up"),
    KEY_DN("Down", "down", "Down"),
    KEY_LEFT("Left", "left", "Left"),
    KEY_RIGHT("Right", "right", "Right"),
    KEY_COMMA("Comma", "comma", ","),
    KEY_PERIOD("Period", "period", "."),
    KEY_BSLASH("Back slash", "backslash", "\\"),
    KEY_SLASH("Forward slash", "forwardslash", "/"),
    KEY_A("a", "a", "A"),
    KEY_S("s", "s", "S"),
    KEY_D("d", "d", "D"),
    KEY_F("f", "f", "F"),
    KEY_G("g", "g", "G"),
    KEY_H("h", "h", "H"),
    KEY_J("j", "j", "J"),
    KEY_K("k", "k", "K"),
    KEY_L("l", "l", "L"),
    KEY_SEMICOLON(";", "semicolon", ";"),
    KEY_QUOTE("'", "apostrophe", "'"),
    KEY_Q("q", "q", "Q"),
    KEY_W("w", "w", "W"),
    KEY_E("e", "e", "E"),
    KEY_R("r", "r", "R"),
    KEY_T("t", "t", "T"),
    KEY_Y("y", "y", "Y"),
    KEY_U("u", "u", "U"),
    KEY_I("i", "i", "I"),
    KEY_O("o", "o", "O"),
    KEY_P("p", "p", "P"),
    KEY_LSB("[", "lbracket", "["),
    KEY_RSB("]", "rbracket", "]"),
    KEY_Z("z", "z", "Z"),
    KEY_X("x", "x", "X"),
    KEY_C("c", "c", "C"),
    KEY_V("v", "v", "V"),
    KEY_B("b", "b", "B"),
    KEY_N("n", "n", "N"),
    KEY_M("m", "m", "M"),
    KEY_ESC("Escape", "Escape", "Escape");

    private String displayName;
    private String keyName;
    private Set<String> aliases;
    private KeyControlSelection[] controls = null;

    private KeyControlSelection(String displayName, String keyName, String ... aliases) {
        this.setDisplayName(displayName);
        this.setKeyName(keyName);
        this.aliases = new HashSet<String>();
        if (aliases != null) {
            for (String alias : aliases) {
                this.aliases.add(alias);
            }
        }
    }

    public boolean isLeftRightControlSelection() {
        return this == KEY_LCTRL || this == KEY_LSHIFT || this == KEY_LALT;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    private void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public KeyControlSelection getControlSelection(String alias, Component parent) {
        if (alias == null) {
            return null;
        }
        System.out.println("pressed " + alias);
        if (this.controls == null) {
            this.controls = new KeyControlSelection[]{KEY_1, KEY_2, KEY_3, KEY_4, KEY_5, KEY_6, KEY_7, KEY_8, KEY_9, KEY_0, KEY_N1, KEY_N2, KEY_N3, KEY_N4, KEY_N5, KEY_N6, KEY_N7, KEY_N8, KEY_N9, KEY_N0, KEY_N_SLASH, KEY_N_AST, KEY_N_SUB, KEY_N_ADD, KEY_N_ENT, KEY_N_PER, KEY_ENTER, KEY_LCTRL, KEY_RCTRL, KEY_LALT, KEY_RALT, KEY_LSHIFT, KEY_RSHIFT, KEY_HOME, KEY_END, KEY_INS, KEY_DEL, KEY_PGUP, KEY_PGDN, KEY_SPACE, KEY_UP, KEY_DN, KEY_LEFT, KEY_RIGHT, KEY_COMMA, KEY_PERIOD, KEY_BSLASH, KEY_SLASH, KEY_A, KEY_S, KEY_D, KEY_F, KEY_G, KEY_H, KEY_J, KEY_K, KEY_L, KEY_SEMICOLON, KEY_QUOTE, KEY_Q, KEY_W, KEY_E, KEY_R, KEY_T, KEY_Y, KEY_U, KEY_I, KEY_O, KEY_P, KEY_LSB, KEY_RSB, KEY_Z, KEY_X, KEY_C, KEY_V, KEY_B, KEY_N, KEY_M, KEY_ESC, KEY_F1, KEY_F2, KEY_F3, KEY_F4, KEY_F5, KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F10, KEY_F11, KEY_F12, KEY_BACKSPACE};
        }
        for (KeyControlSelection control : this.controls) {
            Set<String> strings = control.getAliases();
            if (!strings.contains(alias)) continue;
            if (control.isLeftRightControlSelection()) {
                control = this.showLeftRightControlSelection(control, parent);
            }
            return control;
        }
        return KEY_UNKNOWN;
    }

    private KeyControlSelection showLeftRightControlSelection(KeyControlSelection control, Component parent) {
        if (control == null) {
            return null;
        }
        Object[] choiceTable = new KeyControlSelection[2];
        choiceTable[0] = control;
        if (control == KEY_LSHIFT) {
            choiceTable[1] = KEY_RSHIFT;
        } else if (control == KEY_LCTRL) {
            choiceTable[1] = KEY_RCTRL;
        } else if (control == KEY_LALT) {
            choiceTable[1] = KEY_RALT;
        }
        Integer response = JOptionPane.showOptionDialog(parent, "Choose left or right:", "Left or right?", 2, 3, null, choiceTable, control);
        control = response instanceof Integer && response >= 0 ? choiceTable[response] : null;
        return control;
    }

    public String toString() {
        if (this.getDisplayName() == null) {
            return "";
        }
        return this.getDisplayName();
    }
}

