/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.keypoller;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import mwllactionmapper.enums.GameControlSelection;
import mwllactionmapper.enums.IControlSelection;
import mwllactionmapper.enums.KeyControlSelection;
import mwllactionmapper.enums.MouseControlSelection;
import mwllactionmapper.enums.UnknownControlSelection;
import mwllactionmapper.enums.X360GameControlSelection;
import mwllactionmapper.keypoller.InputComponent;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class JInputScanner {
    Map<Component, Float> map;

    public static void main(String[] args) {
        JInputScanner scanner = new JInputScanner();
        InputComponent inputComponent = scanner.scanInput();
        System.out.println("----");
        System.out.println(inputComponent);
    }

    private InputComponent scanInput() {
        return this.scanInput(null);
    }

    public IControlSelection getControlSelection(JComponent parent) {
        InputComponent inputComponent = this.scanInput(parent);
        if (inputComponent == null) {
            return null;
        }
        Component component = inputComponent.getComponent();
        if (component == null) {
            return null;
        }
        Component.Identifier identifier = component.getIdentifier();
        if (identifier == null) {
            return null;
        }
        Controller parentController = inputComponent.getParentController();
        if (parentController == null) {
            return null;
        }
        Controller.Type type = parentController.getType();
        if (type == null || type.equals(Controller.Type.UNKNOWN)) {
            return null;
        }
        if (type.equals(Controller.Type.KEYBOARD)) {
            return KeyControlSelection.KEY_UNKNOWN.getControlSelection(identifier.getName(), parent);
        }
        if (type.equals(Controller.Type.MOUSE) || type.equals(Controller.Type.TRACKBALL)) {
            return MouseControlSelection.MOUSE_UNKNOWN.getControlSelection(identifier.getName());
        }
        if (type.equals(Controller.Type.GAMEPAD)) {
            if (parentController.getName().contains("Xbox 360")) {
                return X360GameControlSelection.GAME_UNKNOWN.getControlSelection(identifier.getName());
            }
            return GameControlSelection.GAME_UNKNOWN.getControlSelection(identifier.getName());
        }
        if (type.equals(Controller.Type.STICK) || type.equals(Controller.Type.FINGERSTICK) || type.equals(Controller.Type.WHEEL) || type.equals(Controller.Type.RUDDER)) {
            return GameControlSelection.GAME_UNKNOWN.getControlSelection(identifier.getName());
        }
        return UnknownControlSelection.CONTROL_UNKNOWN;
    }

    private InputComponent scanInput(JComponent parent) {
        Component[] components;
        Controller[] controllers = this.initControllers();
        this.map = new HashMap<Component, Float>();
        for (Controller controller : controllers) {
            for (Component component : components = controller.getComponents()) {
                this.map.put(component, Float.valueOf(component.getPollData()));
            }
        }
        block2: while (true) {
            Controller[] arr$ = controllers;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                Controller controller;
                if (i$ >= len$) continue block2;
                controller = arr$[i$];
                controller.poll();
                for (Component component : components = controller.getComponents()) {
                    float currValue;
                    Float prevValue = this.map.get(component);
                    if (prevValue == null) {
                        prevValue = Float.valueOf(0.0f);
                    }
                    if ((currValue = component.getPollData()) == prevValue.floatValue()) continue;
                    if (currValue != 0.0f) {
                        Component.Identifier identifier = component.getIdentifier();
                        if (!component.isAnalog()) {
                            return new InputComponent(controller, component);
                        }
                    }
                    this.map.put(component, Float.valueOf(currValue));
                }
                ++i$;
            }
            break;
        }
    }

    private Controller[] initControllers() {
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        Controller[] controllers = ce.getControllers();
        for (int i = 0; i < controllers.length; ++i) {
            System.out.println(i + "[" + controllers[i].getType() + "]" + "::" + controllers[i].getName());
        }
        return controllers;
    }
}

