/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mwllactionmapper.ActionMaps;
import mwllactionmapper.MWLLActionmapperView;
import mwllactionmapper.model.FileCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionmapsFileModel {
    public static String MWLL_PROFILES_LOCATION;
    public static final String sep;
    public static final String ACTIVE_PREPEND = "active";
    public static final String ACTIONMAPS = "actionmaps";
    public static final String JOYSTICK = "joystick";
    public static final String ORIGINAL = "original";
    public static final String DEFAULT = "default";
    public static final String XML_EXTENSION = ".xml";
    public static final String CFG_EXTENSION = ".cfg";

    public static void init_MWLL_PROFILES_LOCATION() {
        String launchDir = System.getProperty("user.dir").toLowerCase();
        boolean isCrysisLocation = launchDir.contains("crysis") && !launchDir.contains("wars");
        MWLL_PROFILES_LOCATION = isCrysisLocation ? "My Games" + sep + "Crysis" + sep + "Profiles" : "My Games" + sep + "Crysis Wars" + sep + "Profiles";
    }

    public static List<ActionmapsFile> performFirstTimeActionmapsOps(File profileDir) {
        ArrayList<ActionmapsFile> actionmaps = new ArrayList<ActionmapsFile>(1);
        if (profileDir == null) {
            return actionmaps;
        }
        File origActionmapsFile = new File(profileDir, "actionmaps.xml");
        if (origActionmapsFile.exists()) {
            File newActionmapsFile = new File(profileDir, ActionmapsFileModel.createActionmapsFileName(true, ORIGINAL));
            try {
                FileCopy.copy(origActionmapsFile.getAbsolutePath(), newActionmapsFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newActionmapsFile.exists()) {
                actionmaps.add(new ActionmapsFile(newActionmapsFile));
                JOptionPane.showMessageDialog(MWLLActionmapperView.reference.getFrame(), "Since this appears to be the first time using Actionmapper for this profile\nthe orignal actionmaps has been backed up and named 'original'.", "First time original backup created", 1);
            }
        } else {
            ActionMaps.importActionMapsFromStream(MWLLActionmapperView.reference.getClass().getResourceAsStream("resources/actionmaps_default.xml"));
            ActionMaps.exportActionMaps(origActionmapsFile);
            File newActionmapsFile = new File(profileDir, ActionmapsFileModel.createActionmapsFileName(true, DEFAULT));
            try {
                FileCopy.copy(origActionmapsFile.getAbsolutePath(), newActionmapsFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newActionmapsFile.exists()) {
                actionmaps.add(new ActionmapsFile(newActionmapsFile));
                JOptionPane.showMessageDialog(MWLLActionmapperView.reference.getFrame(), "Since this appears to be the first time using Actionmapper for this profile\na new default actionmaps has been created and named 'default'.", "First time default created", 1);
            }
        }
        return actionmaps;
    }

    public static String createActionmapsFileName(boolean isActive, String name) {
        String fileName = "";
        if (isActive) {
            fileName = fileName + "active_";
        }
        fileName = fileName + "actionmaps_" + name + XML_EXTENSION;
        return fileName;
    }

    public static void setActiveActionmaps(ActionmapsFile actionmaps, File profileDir) {
        if (actionmaps == null) {
            return;
        }
        List<ActionmapsFile> files = ActionmapsFileModel.getProfileActionmapsFiles(profileDir);
        for (ActionmapsFile thisFile : files) {
            String newFileName;
            if (actionmaps.equals(thisFile)) {
                newFileName = thisFile.getFile().getName();
                if (!newFileName.startsWith(ACTIVE_PREPEND)) {
                    newFileName = "active_" + newFileName;
                }
                File newFile = new File(profileDir, newFileName);
                thisFile.getFile().renameTo(newFile);
                try {
                    FileCopy.copy(newFile.getAbsolutePath(), new File(profileDir, "actionmaps.xml").getAbsolutePath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                try {
                    FileCopy.copy(new File(profileDir, "joystick_" + thisFile.getActionmapsName() + CFG_EXTENSION).getAbsolutePath(), new File(profileDir, "joystick.cfg").getAbsolutePath());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!thisFile.getFile().getName().startsWith(ACTIVE_PREPEND)) continue;
            newFileName = thisFile.getFile().getName();
            newFileName = newFileName.substring(ACTIVE_PREPEND.length() + 1, newFileName.length());
            thisFile.getFile().renameTo(new File(profileDir, newFileName));
        }
    }

    public static ActionmapsFile getActionmapsFile(String actionmapsName, File profileDir) {
        if (actionmapsName == null) {
            return null;
        }
        List<ActionmapsFile> actionmaps = ActionmapsFileModel.getProfileActionmapsFiles(profileDir);
        for (ActionmapsFile thisActionmaps : actionmaps) {
            if (!actionmapsName.equals(thisActionmaps.getActionmapsName())) continue;
            return thisActionmaps;
        }
        return null;
    }

    public static File getMWLLDocumentsFolder() {
        File documentsFolder = new JFileChooser().getFileSystemView().getDefaultDirectory();
        try {
            File cryDoc = new File(documentsFolder + sep + MWLL_PROFILES_LOCATION);
            if (cryDoc.exists() && cryDoc.canRead()) {
                return cryDoc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<File> getMWLLProfiles() {
        File cryDocsFolder = ActionmapsFileModel.getMWLLDocumentsFolder();
        if (cryDocsFolder == null) {
            return new ArrayList<File>(0);
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] profileDirs = cryDocsFolder.listFiles(fileFilter);
        ArrayList<File> profiles = new ArrayList<File>(profileDirs.length);
        for (File thisProfile : profileDirs) {
            if (thisProfile.getName().equals(DEFAULT)) continue;
            profiles.add(thisProfile);
        }
        return profiles;
    }

    public static List<ActionmapsFile> getProfileActionmapsFiles(File profileDir) {
        File[] fileArr;
        ArrayList<ActionmapsFile> files = new ArrayList<ActionmapsFile>();
        if (profileDir == null) {
            return files;
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                if (!file.getName().endsWith(ActionmapsFileModel.XML_EXTENSION)) {
                    return false;
                }
                return file.getName().contains(ActionmapsFileModel.ACTIONMAPS);
            }
        };
        for (File thisFile : fileArr = profileDir.listFiles(fileFilter)) {
            if (thisFile.getName().equals("actionmaps.xml")) continue;
            ActionmapsFile thisActionmaps = new ActionmapsFile(thisFile);
            files.add(thisActionmaps);
        }
        return files;
    }

    static {
        sep = System.getProperties().getProperty("file.separator");
    }

    public static class ActionmapsFile {
        private File actionmaps;
        private boolean isActive = false;
        private boolean isModified = false;

        public boolean isModified() {
            return this.isModified;
        }

        public long lastModified() {
            if (this.actionmaps != null) {
                return this.actionmaps.lastModified();
            }
            return 0L;
        }

        public void setModified(boolean isModified) {
            this.isModified = isModified;
        }

        public ActionmapsFile(File actionmaps) {
            this.actionmaps = actionmaps;
            this.setActive(actionmaps != null && actionmaps.getName().startsWith(ActionmapsFileModel.ACTIVE_PREPEND));
        }

        public void setActive(boolean active) {
            this.isActive = active;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public File getFile() {
            return this.actionmaps;
        }

        public String getActionmapsName() {
            String name = "";
            if (this.actionmaps == null) {
                return name;
            }
            StringTokenizer tk = new StringTokenizer(this.actionmaps.getName(), "_");
            while (tk.hasMoreTokens()) {
                String thisToken = tk.nextToken();
                if (ActionmapsFileModel.ACTIVE_PREPEND.equals(thisToken) || ActionmapsFileModel.ACTIONMAPS.equals(thisToken)) continue;
                int extIndex = thisToken.indexOf(ActionmapsFileModel.XML_EXTENSION);
                if (extIndex <= 0) break;
                name = thisToken.substring(0, extIndex);
                break;
            }
            return name;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ActionmapsFile)) {
                return false;
            }
            return ((ActionmapsFile)object).getActionmapsName().equals(this.getActionmapsName());
        }

        public String toString() {
            String str = this.getActionmapsName();
            if (this.isActive()) {
                str = str + " (active)";
            }
            return str;
        }
    }
}

