/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class AutoexecModel {
    private static String CRYSIS_AUTOEXEC_LOCATION;
    private static final String AUTOEXEC_FILENAME = "autoexec.cfg";
    private Properties autoexecSettings;
    private List<String> autoexecOrder;
    public static final String invertAeroPitch = "v_invertAeroPitchControl";
    public static final String invertAeroYaw = "v_invertAeroYawControl";
    public static final String invertAeroRoll = "v_invertAeroRollControl";
    public static final String invertVTOLPitch = "v_invertVTOLPitchControl";
    public static final String invertVTOLYaw = "v_invertVTOLYawControl";
    public static final String invertVTOLRoll = "v_invertVTOLRollControl";
    public static final String YES_OPTION = "Yes";
    public static final String YES_VALUE = "1";
    public static final String NO_OPTION = "No";
    public static final String NO_VALUE = "0";

    public static void init_CRYSIS_AUTOEXEC_LOCATION() {
        CRYSIS_AUTOEXEC_LOCATION = "";
        String launchDir = System.getProperty("user.dir");
        if (launchDir.endsWith("\\")) {
            launchDir = launchDir.substring(0, launchDir.length() - 1);
        }
        if (launchDir.contains("NetBeans")) {
            launchDir = "c:\\games\\Crysis Wars\\Mods\\MWLL\\Actionmapper\\dist";
        }
        StringTokenizer tk = new StringTokenizer(launchDir, "\\");
        while (tk.countTokens() > 4) {
            CRYSIS_AUTOEXEC_LOCATION = CRYSIS_AUTOEXEC_LOCATION + tk.nextToken() + "\\";
        }
    }

    public String getPropertyValue(String propertyKey) {
        if (this.autoexecSettings == null) {
            return null;
        }
        return this.autoexecSettings.getProperty(propertyKey);
    }

    public void setPropertyValue(String propertyKey, String propertyValue) {
        if (this.autoexecSettings == null) {
            return;
        }
        this.autoexecSettings.put(propertyKey, propertyValue);
    }

    public void importAutoexecCfgFile() {
        File autoexecFile = new File(CRYSIS_AUTOEXEC_LOCATION, AUTOEXEC_FILENAME);
        this.autoexecSettings = new Properties();
        if (!autoexecFile.exists() || autoexecFile == null) {
            this.createNewAutoexecCfgFile(autoexecFile);
            return;
        }
        try {
            FileInputStream is = new FileInputStream(autoexecFile);
            BufferedReader r = new BufferedReader(new FileReader(autoexecFile));
            this.loadAutoexecSettings(r);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAutoexecSettings(BufferedReader r) {
        this.autoexecOrder = new ArrayList<String>();
        if (r == null || this.autoexecSettings == null) {
            return;
        }
        try {
            String line = r.readLine().trim();
            while (line != null) {
                int equalIndex = line.indexOf("=");
                String keyStr = line;
                if (equalIndex > 0) {
                    keyStr = line.substring(0, equalIndex);
                }
                this.autoexecOrder.add(keyStr);
                if (keyStr.length() > 0 && !keyStr.startsWith(";")) {
                    String valueStr = line.substring(equalIndex + 1);
                    this.autoexecSettings.put(keyStr, valueStr);
                }
                line = r.readLine();
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createNewAutoexecCfgFile(File autoexecFile) {
        if (autoexecFile == null) {
            return;
        }
        this.autoexecOrder = new ArrayList<String>();
        this.autoexecOrder.add(invertAeroPitch);
        this.autoexecOrder.add(invertAeroYaw);
        this.autoexecOrder.add(invertAeroRoll);
        this.autoexecOrder.add(invertVTOLPitch);
        this.autoexecOrder.add(invertVTOLYaw);
        this.autoexecOrder.add(invertVTOLRoll);
        for (String property : this.autoexecOrder) {
            this.autoexecSettings.setProperty(property, NO_VALUE);
        }
    }

    public void exportAutoexecCfg() {
        File autoexecFile = new File(CRYSIS_AUTOEXEC_LOCATION, AUTOEXEC_FILENAME);
        if (this.autoexecSettings == null) {
            return;
        }
        try {
            String value;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(autoexecFile)));
            StringBuffer writeStrBuffer = new StringBuffer();
            for (String key : this.autoexecOrder) {
                value = this.autoexecSettings.getProperty(key);
                if (value != null) {
                    writeStrBuffer.append(key + "=" + value + "\n");
                    continue;
                }
                writeStrBuffer.append(key + "\n");
            }
            for (String key : this.autoexecSettings.stringPropertyNames()) {
                if (this.autoexecOrder.contains(key) || (value = this.autoexecSettings.getProperty(key)) == null) continue;
                writeStrBuffer.append(key + "=" + value + "\n");
            }
            out.write(writeStrBuffer.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

