/*
 * Decompiled with CFR 0.152.
 */
package mwllactionmapper.model;

import javax.swing.DefaultComboBoxModel;
import mwllactionmapper.KeyPanel;

public class KeyModel {
    public static final String AXIS_X = "axis_x";
    public static final String AXIS_Y = "axis_y";
    public static final String AXIS_Z = "axis_z";
    public static final String ROT_X = "rot_x";
    public static final String ROT_Y = "rot_y";
    public static final String ROT_Z = "rot_z";
    public static final String SLIDER_0 = "slider_0";
    public static final String SLIDER_1 = "slider_1";
    public static final String SLIDER_2 = "slider_2";
    public static final String L_THUMB_X = "xi_thumblx";
    public static final String L_THUMB_Y = "xi_thumbly";
    public static final String R_THUMB_X = "xi_thumbrx";
    public static final String R_THUMB_Y = "xi_thumbry";

    public static boolean isKeyAnalog(String keyName) {
        if (keyName == null) {
            return false;
        }
        return keyName.contains(AXIS_X) || keyName.contains(ROT_X) || keyName.contains(AXIS_Y) || keyName.contains(ROT_Y) || keyName.contains(AXIS_Z) || keyName.contains(ROT_Z) || keyName.contains(SLIDER_0) || keyName.contains(SLIDER_1) || keyName.contains(SLIDER_2) || keyName.equals(L_THUMB_X) || keyName.equals(L_THUMB_Y) || keyName.equals(R_THUMB_X) || keyName.equals(R_THUMB_Y);
    }

    public static String getKeyDisplayName(String keyName, boolean showOrigin) {
        KeyPanel.ControlSelection keyControl;
        int i;
        if (keyName == null || keyName.length() == 0 || keyName.equals("null")) {
            return null;
        }
        DefaultComboBoxModel model = KeyModel.populateKeyboardBindings();
        int size = model.getSize();
        for (i = 0; i < size; ++i) {
            keyControl = (KeyPanel.ControlSelection)model.getElementAt(i);
            if (!keyControl.getKeyName().equals(keyName)) continue;
            return (showOrigin ? "Keyboard " : "") + keyControl.getDisplayName();
        }
        model = KeyModel.populateMouseBindings();
        size = model.getSize();
        for (i = 0; i < size; ++i) {
            keyControl = (KeyPanel.ControlSelection)model.getElementAt(i);
            if (!keyControl.getKeyName().equals(keyName)) continue;
            return (showOrigin ? "Mouse " : "") + keyControl.getDisplayName();
        }
        model = KeyModel.populateJoystickBindings();
        size = model.getSize();
        for (i = 0; i < size; ++i) {
            keyControl = (KeyPanel.ControlSelection)model.getElementAt(i);
            if (!keyControl.getKeyName().equals(keyName)) continue;
            return (showOrigin ? "Joystick " : "") + keyControl.getDisplayName();
        }
        model = KeyModel.populateGamepadBindings();
        size = model.getSize();
        for (i = 0; i < size; ++i) {
            keyControl = (KeyPanel.ControlSelection)model.getElementAt(i);
            if (!keyControl.getKeyName().equals(keyName)) continue;
            return (showOrigin ? "Gamepad " : "") + keyControl.getDisplayName();
        }
        return null;
    }

    public static DefaultComboBoxModel populateKeyboardBindings() {
        int i;
        DefaultComboBoxModel<KeyPanel.ControlSelection> model = new DefaultComboBoxModel<KeyPanel.ControlSelection>();
        for (i = 97; i < 123; ++i) {
            char thisChar = (char)i;
            model.addElement(new KeyPanel.ControlSelection(String.valueOf(thisChar), String.valueOf(thisChar)));
        }
        for (i = 0; i < 10; ++i) {
            model.addElement(new KeyPanel.ControlSelection(String.valueOf(i), String.valueOf(i)));
        }
        for (i = 0; i < 10; ++i) {
            model.addElement(new KeyPanel.ControlSelection("Numpad " + i, "np_" + i));
        }
        model.addElement(new KeyPanel.ControlSelection("Numpad /", "np_divide"));
        model.addElement(new KeyPanel.ControlSelection("Numpad *", "np_multiply"));
        model.addElement(new KeyPanel.ControlSelection("Numpad -", "np_subtract"));
        model.addElement(new KeyPanel.ControlSelection("Numpad +", "np_add"));
        model.addElement(new KeyPanel.ControlSelection("Numpad Enter", "np_enter"));
        model.addElement(new KeyPanel.ControlSelection("Numpad .", "np_period"));
        model.addElement(new KeyPanel.ControlSelection("Enter", "enter"));
        model.addElement(new KeyPanel.ControlSelection("Left Control", "lctrl"));
        model.addElement(new KeyPanel.ControlSelection("Right Control", "rctrl"));
        model.addElement(new KeyPanel.ControlSelection("Left Alt", "lalt"));
        model.addElement(new KeyPanel.ControlSelection("Right Alt", "ralt"));
        model.addElement(new KeyPanel.ControlSelection("Left Shift", "lshift"));
        model.addElement(new KeyPanel.ControlSelection("Right Shift", "rshift"));
        model.addElement(new KeyPanel.ControlSelection("Home", "home"));
        model.addElement(new KeyPanel.ControlSelection("End", "end"));
        model.addElement(new KeyPanel.ControlSelection("Insert", "insert"));
        model.addElement(new KeyPanel.ControlSelection("Delete", "delete"));
        model.addElement(new KeyPanel.ControlSelection("Page Up", "pgup"));
        model.addElement(new KeyPanel.ControlSelection("Page Down", "pgdn"));
        model.addElement(new KeyPanel.ControlSelection("Backspace", "backspace"));
        model.addElement(new KeyPanel.ControlSelection("Spacebar", "space"));
        model.addElement(new KeyPanel.ControlSelection("Up", "up"));
        model.addElement(new KeyPanel.ControlSelection("Down", "down"));
        model.addElement(new KeyPanel.ControlSelection("Left", "left"));
        model.addElement(new KeyPanel.ControlSelection("Right", "right"));
        model.addElement(new KeyPanel.ControlSelection("Comma", "comma"));
        model.addElement(new KeyPanel.ControlSelection("Period", "period"));
        model.addElement(new KeyPanel.ControlSelection("Back Slash", "backslash"));
        model.addElement(new KeyPanel.ControlSelection("Forward Slash", "forwardslash"));
        model.addElement(new KeyPanel.ControlSelection("Left Bracket", "lbracket"));
        model.addElement(new KeyPanel.ControlSelection("Right Bracket", "rbracket"));
        model.addElement(new KeyPanel.ControlSelection("Semicolon", "semicolon"));
        model.addElement(new KeyPanel.ControlSelection("Apostrophe", "apostrophe"));
        model.addElement(new KeyPanel.ControlSelection("Minus", "minus"));
        model.addElement(new KeyPanel.ControlSelection("Equals", "equals"));
        for (i = 1; i <= 12; ++i) {
            model.addElement(new KeyPanel.ControlSelection("F" + i, "f" + i));
        }
        return model;
    }

    public static DefaultComboBoxModel populateMouseBindings() {
        DefaultComboBoxModel<KeyPanel.ControlSelection> model = new DefaultComboBoxModel<KeyPanel.ControlSelection>();
        for (int i = 1; i <= 6; ++i) {
            model.addElement(new KeyPanel.ControlSelection("Button " + i, "mouse" + i));
        }
        model.addElement(new KeyPanel.ControlSelection("X Axis", "maxis_x"));
        model.addElement(new KeyPanel.ControlSelection("Y Axis", "maxis_y"));
        model.addElement(new KeyPanel.ControlSelection("Mousewheel Up", "mwheel_up"));
        model.addElement(new KeyPanel.ControlSelection("Mousewheel Down", "mwheel_down"));
        return model;
    }

    public static DefaultComboBoxModel populateJoystickBindings() {
        DefaultComboBoxModel<KeyPanel.ControlSelection> model = new DefaultComboBoxModel<KeyPanel.ControlSelection>();
        model.addElement(new KeyPanel.ControlSelection("X Axis", "joyaxis_x"));
        model.addElement(new KeyPanel.ControlSelection("Y Axis", "joyaxis_y"));
        model.addElement(new KeyPanel.ControlSelection("Z Axis", "joyaxis_z"));
        model.addElement(new KeyPanel.ControlSelection("X Rotation", "joyrot_x"));
        model.addElement(new KeyPanel.ControlSelection("Y Rotation", "joyrot_y"));
        model.addElement(new KeyPanel.ControlSelection("Z Rotation", "joyrot_z"));
        model.addElement(new KeyPanel.ControlSelection("Slider 0", SLIDER_0));
        model.addElement(new KeyPanel.ControlSelection("Slider 1", SLIDER_1));
        model.addElement(new KeyPanel.ControlSelection("Slider 2", SLIDER_2));
        for (int i = 1; i <= 64; ++i) {
            model.addElement(new KeyPanel.ControlSelection("Button " + i, "joybut_" + i));
        }
        return model;
    }

    public static DefaultComboBoxModel populateGamepadBindings() {
        DefaultComboBoxModel<KeyPanel.ControlSelection> model = new DefaultComboBoxModel<KeyPanel.ControlSelection>();
        model.addElement(new KeyPanel.ControlSelection("A Button", "xi_a"));
        model.addElement(new KeyPanel.ControlSelection("B Button", "xi_b"));
        model.addElement(new KeyPanel.ControlSelection("X Button", "xi_x"));
        model.addElement(new KeyPanel.ControlSelection("Y Button", "xi_y"));
        model.addElement(new KeyPanel.ControlSelection("Back", "xi_back"));
        model.addElement(new KeyPanel.ControlSelection("Start", "xi_start"));
        model.addElement(new KeyPanel.ControlSelection("Right Trigger", "xi_triggerr_btn"));
        model.addElement(new KeyPanel.ControlSelection("Left Trigger", "xi_triggerl_btn"));
        model.addElement(new KeyPanel.ControlSelection("Right Shoulder", "xi_shoulderr"));
        model.addElement(new KeyPanel.ControlSelection("Left Shoulder", "xi_shoulderl"));
        model.addElement(new KeyPanel.ControlSelection("Right Stick Button", "xi_thumbr"));
        model.addElement(new KeyPanel.ControlSelection("Left Stick Button", "xi_thumbl"));
        model.addElement(new KeyPanel.ControlSelection("Direction Pad Up", "xi_dpad_up"));
        model.addElement(new KeyPanel.ControlSelection("Direction Pad Down", "xi_dpad_down"));
        model.addElement(new KeyPanel.ControlSelection("Direction Pad Left", "xi_dpad_left"));
        model.addElement(new KeyPanel.ControlSelection("Direction Pad Right", "xi_dpad_right"));
        model.addElement(new KeyPanel.ControlSelection("Left Stick Axis Up/Down", L_THUMB_Y));
        model.addElement(new KeyPanel.ControlSelection("Left Stick Axis Left/Right", L_THUMB_X));
        model.addElement(new KeyPanel.ControlSelection("Right Stick Axis Up/Down", R_THUMB_Y));
        model.addElement(new KeyPanel.ControlSelection("Right Stick Axis Left/Right", R_THUMB_X));
        return model;
    }
}

